/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jreleaser.maven.plugin.EnabledAware;
import org.jreleaser.model.Active;
import org.jreleaser.util.StringUtils;

public class Changelog
implements EnabledAware {
    private final Set<String> includeLabels = new LinkedHashSet<String>();
    private final Set<String> excludeLabels = new LinkedHashSet<String>();
    private final List<Category> categories = new ArrayList<Category>();
    private final List<Replacer> replacers = new ArrayList<Replacer>();
    private final List<Labeler> labelers = new ArrayList<Labeler>();
    private final Contributors contributors = new Contributors();
    private final Hide hide = new Hide();
    private Boolean enabled;
    private boolean links;
    private Sort sort = Sort.DESC;
    private String external;
    private Active formatted;
    private String change;
    private String format;
    private String content;
    private String contentTemplate;
    private String preset;

    void setAll(Changelog changelog) {
        this.enabled = changelog.enabled;
        this.links = changelog.links;
        this.sort = changelog.sort;
        this.external = changelog.external;
        this.formatted = changelog.formatted;
        this.change = changelog.change;
        this.format = changelog.format;
        this.content = changelog.content;
        this.contentTemplate = changelog.contentTemplate;
        this.preset = changelog.preset;
        this.setIncludeLabels(changelog.includeLabels);
        this.setExcludeLabels(changelog.excludeLabels);
        this.setCategories(changelog.categories);
        this.setReplacers(changelog.replacers);
        this.setLabelers(changelog.labelers);
        this.setContributors(changelog.contributors);
        this.setHide(changelog.hide);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public boolean isLinks() {
        return this.links;
    }

    public void setLinks(boolean links) {
        this.links = links;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public void setSort(String sort) {
        if (StringUtils.isNotBlank((String)sort)) {
            this.setSort(Sort.valueOf(sort.toUpperCase()));
        }
    }

    public String getExternal() {
        return this.external;
    }

    public void setExternal(String external) {
        this.external = external;
    }

    public String resolveFormatted() {
        return this.formatted != null ? this.formatted.name() : null;
    }

    public Active getFormatted() {
        return this.formatted;
    }

    public void setFormatted(Active formatted) {
        this.formatted = formatted;
    }

    public void setFormatted(String str) {
        this.formatted = Active.of((String)str);
    }

    public boolean isFormattedSet() {
        return this.formatted != null;
    }

    public Set<String> getIncludeLabels() {
        return this.includeLabels;
    }

    public void setIncludeLabels(Set<String> includeLabels) {
        this.includeLabels.clear();
        this.includeLabels.addAll(includeLabels);
    }

    public Set<String> getExcludeLabels() {
        return this.excludeLabels;
    }

    public void setExcludeLabels(Set<String> excludeLabels) {
        this.excludeLabels.clear();
        this.excludeLabels.addAll(excludeLabels);
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories.clear();
        this.categories.addAll(categories);
    }

    public List<Replacer> getReplacers() {
        return this.replacers;
    }

    public void setReplacers(List<Replacer> replacers) {
        this.replacers.clear();
        this.replacers.addAll(replacers);
    }

    public List<Labeler> getLabelers() {
        return this.labelers;
    }

    public void setLabelers(List<Labeler> labelers) {
        this.labelers.clear();
        this.labelers.addAll(labelers);
    }

    public String getChange() {
        return this.change;
    }

    public void setChange(String change) {
        this.change = change;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentTemplate() {
        return this.contentTemplate;
    }

    public void setContentTemplate(String contentTemplate) {
        this.contentTemplate = contentTemplate;
    }

    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    @Deprecated
    public boolean isHideUncategorized() {
        return this.hide.isUncategorized();
    }

    @Deprecated
    public void setHideUncategorized(boolean hideUncategorized) {
        this.hide.setUncategorized(hideUncategorized);
    }

    public Contributors getContributors() {
        return this.contributors;
    }

    public void setContributors(Contributors contributors) {
        this.contributors.setAll(contributors);
    }

    public Hide getHide() {
        return this.hide;
    }

    public void setHide(Hide hide) {
        this.hide.setAll(hide);
    }

    public static class Hide {
        private final Set<String> categories = new LinkedHashSet<String>();
        private final Set<String> contributors = new LinkedHashSet<String>();
        private boolean uncategorized;

        void setAll(Hide hide) {
            this.uncategorized = hide.uncategorized;
            this.setCategories(hide.categories);
            this.setContributors(hide.contributors);
        }

        public boolean isUncategorized() {
            return this.uncategorized;
        }

        public void setUncategorized(boolean uncategorized) {
            this.uncategorized = uncategorized;
        }

        public Set<String> getCategories() {
            return this.categories;
        }

        public void setCategories(Set<String> categories) {
            this.categories.clear();
            this.categories.addAll(categories.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public Set<String> getContributors() {
            return this.contributors;
        }

        public void setContributors(Set<String> contributors) {
            this.contributors.clear();
            this.contributors.addAll(contributors.stream().map(String::trim).collect(Collectors.toSet()));
        }
    }

    public static class Contributors {
        private Boolean enabled;
        private String format;

        void setAll(Contributors contributor) {
            this.enabled = contributor.enabled;
            this.format = contributor.format;
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }

    public static class Labeler {
        private String label;
        private String branch;
        private String title;
        private String body;
        private Integer order;

        void setAll(Labeler labeler) {
            this.label = labeler.label;
            this.branch = labeler.branch;
            this.title = labeler.title;
            this.body = labeler.body;
            this.order = labeler.order;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getBranch() {
            return this.branch;
        }

        public void setBranch(String branch) {
            this.branch = branch;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }
    }

    public static class Replacer {
        private String search;
        private String replace = "";

        void setAll(Replacer replacer) {
            this.search = replacer.search;
            this.replace = replacer.replace;
        }

        public String getSearch() {
            return this.search;
        }

        public void setSearch(String search) {
            this.search = search;
        }

        public String getReplace() {
            return this.replace;
        }

        public void setReplace(String replace) {
            this.replace = replace;
        }
    }

    public static class Category {
        private final Set<String> labels = new LinkedHashSet<String>();
        private String title;
        private String format;
        private Integer order;

        void setAll(Category category) {
            this.title = category.title;
            this.setLabels(category.labels);
            this.format = category.format;
            this.order = category.order;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Set<String> getLabels() {
            return this.labels;
        }

        public void setLabels(Set<String> labels) {
            this.labels.clear();
            this.labels.addAll(labels);
        }

        public void setLabelsAsString(String str) {
            if (StringUtils.isNotBlank((String)str)) {
                this.setLabels(Stream.of(str.split(",")).map(String::trim).collect(Collectors.toSet()));
            }
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public static Category of(String title, String format, String ... labels) {
            Category category = new Category();
            category.title = title;
            category.format = format;
            category.labels.addAll(Arrays.asList(labels));
            return category;
        }
    }

    public static enum Sort {
        ASC,
        DESC;

    }
}

