/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.maven.plugin.Activatable;
import org.jreleaser.maven.plugin.Active;
import org.jreleaser.maven.plugin.Artifact;
import org.jreleaser.maven.plugin.ExtraProperties;
import org.jreleaser.maven.plugin.Java;
import org.jreleaser.maven.plugin.Packagers;

public class Distribution
extends Packagers
implements ExtraProperties,
Activatable {
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
    private final Java java = new Java();
    private String name;
    private DistributionType type = DistributionType.JAVA_BINARY;
    private String executable;
    private String executableExtension;
    private Active active;

    void setAll(Distribution distribution) {
        super.setAll(distribution);
        this.active = distribution.active;
        this.name = distribution.name;
        this.type = distribution.type;
        this.executable = distribution.executable;
        this.executableExtension = distribution.executableExtension;
        this.java.setAll(distribution.java);
        this.setTags(distribution.tags);
        this.setExtraProperties(distribution.extraProperties);
        this.setArtifacts(distribution.artifacts);
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public String resolveActive() {
        return this.active != null ? this.active.name() : null;
    }

    public DistributionType getType() {
        return this.type;
    }

    public void setType(DistributionType type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = DistributionType.valueOf(type.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public String getExecutableExtension() {
        return this.executableExtension;
    }

    public void setExecutableExtension(String executableExtension) {
        this.executableExtension = executableExtension;
    }

    public Java getJava() {
        return this.java;
    }

    public void setJava(Java java) {
        this.java.setAll(java);
    }

    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    public static enum DistributionType {
        BINARY,
        JAVA_BINARY,
        JLINK,
        SINGLE_JAR,
        NATIVE_IMAGE,
        NATIVE_PACKAGE;

    }
}

