/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jreleaser.maven.plugin.Announce;
import org.jreleaser.maven.plugin.Announcer;
import org.jreleaser.maven.plugin.Archive;
import org.jreleaser.maven.plugin.Article;
import org.jreleaser.maven.plugin.Artifact;
import org.jreleaser.maven.plugin.Artifactory;
import org.jreleaser.maven.plugin.Assemble;
import org.jreleaser.maven.plugin.Brew;
import org.jreleaser.maven.plugin.Bucket;
import org.jreleaser.maven.plugin.Cask;
import org.jreleaser.maven.plugin.Catalog;
import org.jreleaser.maven.plugin.Changelog;
import org.jreleaser.maven.plugin.Checksum;
import org.jreleaser.maven.plugin.Chocolatey;
import org.jreleaser.maven.plugin.Codeberg;
import org.jreleaser.maven.plugin.CommitAuthor;
import org.jreleaser.maven.plugin.Discord;
import org.jreleaser.maven.plugin.Discussions;
import org.jreleaser.maven.plugin.Distribution;
import org.jreleaser.maven.plugin.Docker;
import org.jreleaser.maven.plugin.DockerConfiguration;
import org.jreleaser.maven.plugin.DockerRepository;
import org.jreleaser.maven.plugin.DockerSpec;
import org.jreleaser.maven.plugin.Environment;
import org.jreleaser.maven.plugin.FileSet;
import org.jreleaser.maven.plugin.Files;
import org.jreleaser.maven.plugin.GenericGit;
import org.jreleaser.maven.plugin.GitService;
import org.jreleaser.maven.plugin.Gitea;
import org.jreleaser.maven.plugin.Github;
import org.jreleaser.maven.plugin.Gitlab;
import org.jreleaser.maven.plugin.Gitter;
import org.jreleaser.maven.plugin.Glob;
import org.jreleaser.maven.plugin.GoogleChat;
import org.jreleaser.maven.plugin.Http;
import org.jreleaser.maven.plugin.Java;
import org.jreleaser.maven.plugin.Jbang;
import org.jreleaser.maven.plugin.Jdeps;
import org.jreleaser.maven.plugin.Jlink;
import org.jreleaser.maven.plugin.Jreleaser;
import org.jreleaser.maven.plugin.Macports;
import org.jreleaser.maven.plugin.Mail;
import org.jreleaser.maven.plugin.Mastodon;
import org.jreleaser.maven.plugin.Mattermost;
import org.jreleaser.maven.plugin.Milestone;
import org.jreleaser.maven.plugin.NativeImage;
import org.jreleaser.maven.plugin.Packagers;
import org.jreleaser.maven.plugin.Plug;
import org.jreleaser.maven.plugin.Project;
import org.jreleaser.maven.plugin.Registry;
import org.jreleaser.maven.plugin.Release;
import org.jreleaser.maven.plugin.S3;
import org.jreleaser.maven.plugin.Scoop;
import org.jreleaser.maven.plugin.Sdkman;
import org.jreleaser.maven.plugin.SdkmanAnnouncer;
import org.jreleaser.maven.plugin.Signing;
import org.jreleaser.maven.plugin.Slack;
import org.jreleaser.maven.plugin.Slot;
import org.jreleaser.maven.plugin.Snap;
import org.jreleaser.maven.plugin.Spec;
import org.jreleaser.maven.plugin.Tap;
import org.jreleaser.maven.plugin.Teams;
import org.jreleaser.maven.plugin.Telegram;
import org.jreleaser.maven.plugin.Twitter;
import org.jreleaser.maven.plugin.Upload;
import org.jreleaser.maven.plugin.Uploader;
import org.jreleaser.maven.plugin.Webhook;
import org.jreleaser.maven.plugin.Zulip;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.ChocolateyBucket;
import org.jreleaser.model.GitService;
import org.jreleaser.model.HomebrewTap;
import org.jreleaser.model.HttpUploader;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.JbangCatalog;
import org.jreleaser.model.MacportsRepository;
import org.jreleaser.model.Project;
import org.jreleaser.model.Repository;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.model.ScoopBucket;
import org.jreleaser.model.SnapTap;
import org.jreleaser.model.SpecRepository;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.util.StringUtils;
import org.jsoup.parser.Parser;

public final class JReleaserModelConverter {
    private static final Pattern ESCAPED_ENTITY = Pattern.compile(".*&#(?:[xX][a-fA-F0-9]+|[0-9]+);.*");

    private JReleaserModelConverter() {
    }

    private static String tr(String str) {
        if (StringUtils.isNotBlank((String)str) && ESCAPED_ENTITY.matcher(str).matches()) {
            return Parser.unescapeEntities((String)str, (boolean)true);
        }
        return str;
    }

    private static List<String> tr(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, JReleaserModelConverter.tr(list.get(i)));
        }
        return list;
    }

    private static Set<String> tr(Set<String> input) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String s : input) {
            set.add(JReleaserModelConverter.tr(s));
        }
        return set;
    }

    public static JReleaserModel convert(Jreleaser jreleaser) {
        JReleaserModel jreleaserModel = new JReleaserModel();
        jreleaserModel.setEnvironment(JReleaserModelConverter.convertEnvironment(jreleaser.getEnvironment()));
        jreleaserModel.setProject(JReleaserModelConverter.convertProject(jreleaser.getProject()));
        jreleaserModel.setRelease(JReleaserModelConverter.convertRelease(jreleaser.getRelease()));
        jreleaserModel.setUpload(JReleaserModelConverter.convertUpload(jreleaser.getUpload()));
        jreleaserModel.setPackagers(JReleaserModelConverter.convertPackagers(jreleaser.getPackagers()));
        jreleaserModel.setAnnounce(JReleaserModelConverter.convertAnnounce(jreleaser.getAnnounce()));
        jreleaserModel.setAssemble(JReleaserModelConverter.convertAssemble(jreleaser.getAssemble()));
        jreleaserModel.setChecksum(JReleaserModelConverter.convertChecksum(jreleaser.getChecksum()));
        jreleaserModel.setSigning(JReleaserModelConverter.convertSigning(jreleaser.getSigning()));
        jreleaserModel.setFiles(JReleaserModelConverter.convertFiles(jreleaser.getFiles()));
        jreleaserModel.setDistributions(JReleaserModelConverter.convertDistributions(jreleaser.getDistributions()));
        return jreleaserModel;
    }

    private static org.jreleaser.model.Environment convertEnvironment(Environment environment) {
        org.jreleaser.model.Environment e = new org.jreleaser.model.Environment();
        e.setVariables(environment.getVariables());
        e.setProperties(environment.getProperties());
        return e;
    }

    private static org.jreleaser.model.Project convertProject(Project project) {
        org.jreleaser.model.Project p = new org.jreleaser.model.Project();
        p.setName(JReleaserModelConverter.tr(project.getName()));
        p.setVersion(JReleaserModelConverter.tr(project.getVersion()));
        p.setVersionPattern(JReleaserModelConverter.tr(project.getVersionPattern()));
        if (StringUtils.isNotBlank((String)project.getSnapshotPattern())) {
            p.setSnapshotPattern(project.getSnapshotPattern());
        }
        p.setSnapshot(JReleaserModelConverter.convertSnapshot(project.getSnapshot()));
        p.setDescription(JReleaserModelConverter.tr(project.getDescription()));
        p.setLongDescription(JReleaserModelConverter.tr(project.getLongDescription()));
        p.setWebsite(JReleaserModelConverter.tr(project.getWebsite()));
        p.setLicense(JReleaserModelConverter.tr(project.getLicense()));
        p.setLicenseUrl(JReleaserModelConverter.tr(project.getLicenseUrl()));
        p.setCopyright(JReleaserModelConverter.tr(project.getCopyright()));
        p.setVendor(JReleaserModelConverter.tr(project.getVendor()));
        p.setDocsUrl(JReleaserModelConverter.tr(project.getDocsUrl()));
        p.setTags(JReleaserModelConverter.tr(project.getTags()));
        p.setAuthors(JReleaserModelConverter.tr(project.getAuthors()));
        p.setExtraProperties(project.getExtraProperties());
        p.setJava(JReleaserModelConverter.convertJava(project.getJava()));
        return p;
    }

    private static Project.Snapshot convertSnapshot(Project.Snapshot snapshot) {
        Project.Snapshot s = new Project.Snapshot();
        s.setPattern(JReleaserModelConverter.tr(snapshot.getPattern()));
        s.setLabel(JReleaserModelConverter.tr(snapshot.getLabel()));
        if (snapshot.isFullChangelogSet()) {
            s.setFullChangelog(Boolean.valueOf(snapshot.isFullChangelog()));
        }
        return s;
    }

    private static org.jreleaser.model.Java convertJava(Java java) {
        org.jreleaser.model.Java j = new org.jreleaser.model.Java();
        j.setEnabled(Boolean.valueOf(true));
        j.setGroupId(JReleaserModelConverter.tr(java.getGroupId()));
        j.setArtifactId(JReleaserModelConverter.tr(java.getArtifactId()));
        j.setVersion(JReleaserModelConverter.tr(java.getVersion()));
        j.setMainClass(JReleaserModelConverter.tr(java.getMainClass()));
        if (java.isMultiProjectSet()) {
            j.setMultiProject(java.isMultiProject().booleanValue());
        }
        return j;
    }

    private static org.jreleaser.model.Release convertRelease(Release release) {
        org.jreleaser.model.Release r = new org.jreleaser.model.Release();
        r.setGithub(JReleaserModelConverter.convertGithub(release.getGithub()));
        r.setGitlab(JReleaserModelConverter.convertGitlab(release.getGitlab()));
        r.setGitea(JReleaserModelConverter.convertGitea(release.getGitea()));
        r.setCodeberg(JReleaserModelConverter.convertCodeberg(release.getCodeberg()));
        r.setGeneric(JReleaserModelConverter.convertGeneric(release.getGeneric()));
        return r;
    }

    private static org.jreleaser.model.Github convertGithub(Github github) {
        if (null == github) {
            return null;
        }
        org.jreleaser.model.Github g = new org.jreleaser.model.Github();
        JReleaserModelConverter.convertGitService(github, (org.jreleaser.model.GitService)g);
        g.setDraft(Boolean.valueOf(github.isDraft()));
        if (github.isPrereleaseEnabledSet()) {
            g.setPrerelease(new GitService.Prerelease(github.getPrereleaseEnabled()));
        }
        g.setPrerelease(JReleaserModelConverter.convertPrerelease(github.getPrerelease()));
        g.setDiscussionCategoryName(JReleaserModelConverter.tr(github.getDiscussionCategoryName()));
        return g;
    }

    private static org.jreleaser.model.Gitlab convertGitlab(Gitlab gitlab) {
        if (null == gitlab) {
            return null;
        }
        org.jreleaser.model.Gitlab g = new org.jreleaser.model.Gitlab();
        JReleaserModelConverter.convertGitService(gitlab, (org.jreleaser.model.GitService)g);
        g.setIdentifier(JReleaserModelConverter.tr(gitlab.getIdentifier()));
        return g;
    }

    private static org.jreleaser.model.Gitea convertGitea(Gitea gitea) {
        if (null == gitea) {
            return null;
        }
        org.jreleaser.model.Gitea g = new org.jreleaser.model.Gitea();
        JReleaserModelConverter.convertGitService(gitea, (org.jreleaser.model.GitService)g);
        g.setDraft(Boolean.valueOf(gitea.isDraft()));
        if (gitea.isPrereleaseEnabledSet()) {
            g.setPrerelease(new GitService.Prerelease(gitea.getPrereleaseEnabled()));
        }
        g.setPrerelease(JReleaserModelConverter.convertPrerelease(gitea.getPrerelease()));
        return g;
    }

    private static org.jreleaser.model.Codeberg convertCodeberg(Codeberg codeberg) {
        if (null == codeberg) {
            return null;
        }
        org.jreleaser.model.Codeberg g = new org.jreleaser.model.Codeberg();
        JReleaserModelConverter.convertGitService(codeberg, (org.jreleaser.model.GitService)g);
        g.setDraft(Boolean.valueOf(codeberg.isDraft()));
        if (codeberg.isPrereleaseEnabledSet()) {
            g.setPrerelease(new GitService.Prerelease(codeberg.getPrereleaseEnabled()));
        }
        g.setPrerelease(JReleaserModelConverter.convertPrerelease(codeberg.getPrerelease()));
        return g;
    }

    private static GitService.Prerelease convertPrerelease(GitService.Prerelease prerelease) {
        GitService.Prerelease s = new GitService.Prerelease();
        s.setPattern(JReleaserModelConverter.tr(prerelease.getPattern()));
        s.setEnabled(prerelease.getEnabled());
        return s;
    }

    private static org.jreleaser.model.GenericGit convertGeneric(GenericGit generic) {
        if (null == generic) {
            return null;
        }
        org.jreleaser.model.GenericGit g = new org.jreleaser.model.GenericGit();
        JReleaserModelConverter.convertGitService(generic, (org.jreleaser.model.GitService)g);
        return g;
    }

    private static void convertGitService(GitService service, org.jreleaser.model.GitService s) {
        if (StringUtils.isNotBlank((String)service.getHost())) {
            s.setHost(JReleaserModelConverter.tr(service.getHost()));
        }
        if (StringUtils.isNotBlank((String)service.getOwner())) {
            s.setOwner(JReleaserModelConverter.tr(service.getOwner()));
        }
        if (StringUtils.isNotBlank((String)service.getName())) {
            s.setName(JReleaserModelConverter.tr(service.getName()));
        }
        if (StringUtils.isNotBlank((String)service.getRepoUrl())) {
            s.setRepoUrl(JReleaserModelConverter.tr(service.getRepoUrl()));
        }
        if (StringUtils.isNotBlank((String)service.getRepoCloneUrl())) {
            s.setRepoCloneUrl(JReleaserModelConverter.tr(service.getRepoCloneUrl()));
        }
        if (StringUtils.isNotBlank((String)service.getCommitUrl())) {
            s.setCommitUrl(JReleaserModelConverter.tr(service.getCommitUrl()));
        }
        if (StringUtils.isNotBlank((String)service.getSrcUrl())) {
            s.setCommitUrl(JReleaserModelConverter.tr(service.getSrcUrl()));
        }
        if (StringUtils.isNotBlank((String)service.getDownloadUrl())) {
            s.setDownloadUrl(JReleaserModelConverter.tr(service.getDownloadUrl()));
        }
        if (StringUtils.isNotBlank((String)service.getReleaseNotesUrl())) {
            s.setReleaseNotesUrl(JReleaserModelConverter.tr(service.getReleaseNotesUrl()));
        }
        if (StringUtils.isNotBlank((String)service.getLatestReleaseUrl())) {
            s.setLatestReleaseUrl(JReleaserModelConverter.tr(service.getLatestReleaseUrl()));
        }
        if (StringUtils.isNotBlank((String)service.getIssueTrackerUrl())) {
            s.setIssueTrackerUrl(JReleaserModelConverter.tr(service.getIssueTrackerUrl()));
        }
        if (StringUtils.isNotBlank((String)service.getUsername())) {
            s.setUsername(JReleaserModelConverter.tr(service.getUsername()));
        }
        if (StringUtils.isNotBlank((String)service.getToken())) {
            s.setToken(JReleaserModelConverter.tr(service.getToken()));
        }
        if (StringUtils.isNotBlank((String)service.getTagName())) {
            s.setTagName(JReleaserModelConverter.tr(service.getTagName()));
        }
        if (StringUtils.isNotBlank((String)service.getPreviousTagName())) {
            s.setPreviousTagName(JReleaserModelConverter.tr(service.getPreviousTagName()));
        }
        if (StringUtils.isNotBlank((String)service.getReleaseName())) {
            s.setReleaseName(JReleaserModelConverter.tr(service.getReleaseName()));
        }
        if (StringUtils.isNotBlank((String)service.getBranch())) {
            s.setBranch(JReleaserModelConverter.tr(service.getBranch()));
        }
        s.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(service.getCommitAuthor()));
        s.setSign(service.isSign());
        if (service.isSkipTagSet()) {
            s.setSkipTag(Boolean.valueOf(service.isSkipTag()));
        }
        if (service.isSkipReleaseSet()) {
            s.setSkipRelease(Boolean.valueOf(service.isSkipRelease()));
        }
        if (service.isOverwriteSet()) {
            s.setOverwrite(Boolean.valueOf(service.isOverwrite()));
        }
        if (service.isUpdateSet()) {
            s.setUpdate(Boolean.valueOf(service.isUpdate()));
            s.setUpdateSections(JReleaserModelConverter.convertUpdateSections(service.getUpdateSections()));
        }
        if (StringUtils.isNotBlank((String)service.getApiEndpoint())) {
            s.setApiEndpoint(JReleaserModelConverter.tr(service.getApiEndpoint()));
        }
        s.setChangelog(JReleaserModelConverter.convertChangelog(service.getChangelog()));
        s.setMilestone(JReleaserModelConverter.convertMilestone(service.getMilestone()));
        s.setConnectTimeout(service.getConnectTimeout());
        s.setReadTimeout(service.getReadTimeout());
        if (service.isArtifactsSet()) {
            s.setArtifacts(service.isArtifacts());
        }
        if (service.isFilesSet()) {
            s.setFiles(service.isFiles());
        }
        if (service.isChecksumsSet()) {
            s.setChecksums(service.isChecksums());
        }
        if (service.isSignaturesSet()) {
            s.setSignatures(service.isSignatures());
        }
    }

    private static Set<UpdateSection> convertUpdateSections(Set<UpdateSection> updateSections) {
        return updateSections.stream().map(s -> UpdateSection.of((String)s.name())).collect(Collectors.toSet());
    }

    private static org.jreleaser.model.CommitAuthor convertCommitAuthor(CommitAuthor commitAuthor) {
        org.jreleaser.model.CommitAuthor ca = new org.jreleaser.model.CommitAuthor();
        ca.setName(JReleaserModelConverter.tr(commitAuthor.getName()));
        ca.setEmail(JReleaserModelConverter.tr(commitAuthor.getEmail()));
        return ca;
    }

    private static org.jreleaser.model.Changelog convertChangelog(Changelog changelog) {
        org.jreleaser.model.Changelog c = new org.jreleaser.model.Changelog();
        if (changelog.isEnabledSet()) {
            c.setEnabled(Boolean.valueOf(changelog.isEnabled()));
        }
        c.setSort(changelog.getSort().name());
        c.setExternal(JReleaserModelConverter.tr(changelog.getExternal()));
        c.setFormatted(JReleaserModelConverter.tr(changelog.resolveFormatted()));
        c.getIncludeLabels().addAll(JReleaserModelConverter.tr(changelog.getIncludeLabels()));
        c.getExcludeLabels().addAll(JReleaserModelConverter.tr(changelog.getExcludeLabels()));
        if (StringUtils.isNotBlank((String)changelog.getChange())) {
            c.setChange(changelog.getChange());
        }
        c.setFormat(JReleaserModelConverter.tr(changelog.getFormat()));
        c.setContent(JReleaserModelConverter.tr(changelog.getContent()));
        c.setContentTemplate(JReleaserModelConverter.tr(changelog.getContentTemplate()));
        c.setPreset(JReleaserModelConverter.tr(changelog.getPreset()));
        c.setCategories(JReleaserModelConverter.convertCategories(changelog.getCategories()));
        c.setLabelers(JReleaserModelConverter.convertLabelers(changelog.getLabelers()));
        c.setReplacers(JReleaserModelConverter.convertReplacers(changelog.getReplacers()));
        c.setHide(JReleaserModelConverter.convertHide(changelog.getHide()));
        c.setContributors(JReleaserModelConverter.convertContributors(changelog.getContributors()));
        return c;
    }

    private static Changelog.Hide convertHide(Changelog.Hide hide) {
        Changelog.Hide h = new Changelog.Hide();
        h.setUncategorized(hide.isUncategorized());
        h.setCategories(JReleaserModelConverter.tr(hide.getCategories()));
        h.setContributors(JReleaserModelConverter.tr(hide.getContributors()));
        return h;
    }

    private static Changelog.Contributors convertContributors(Changelog.Contributors contributors) {
        Changelog.Contributors c = new Changelog.Contributors();
        if (contributors.isEnabledSet()) {
            c.setEnabled(Boolean.valueOf(contributors.isEnabled()));
        }
        c.setFormat(JReleaserModelConverter.tr(contributors.getFormat()));
        return c;
    }

    private static Set<Changelog.Category> convertCategories(Collection<Changelog.Category> categories) {
        LinkedHashSet<Changelog.Category> set = new LinkedHashSet<Changelog.Category>();
        for (Changelog.Category category : categories) {
            Changelog.Category c = new Changelog.Category();
            c.setTitle(JReleaserModelConverter.tr(category.getTitle()));
            c.setLabels(category.getLabels());
            c.setFormat(JReleaserModelConverter.tr(category.getFormat()));
            c.setOrder(category.getOrder());
            set.add(c);
        }
        return set;
    }

    private static Set<Changelog.Labeler> convertLabelers(Collection<Changelog.Labeler> labelers) {
        LinkedHashSet<Changelog.Labeler> set = new LinkedHashSet<Changelog.Labeler>();
        for (Changelog.Labeler labeler : labelers) {
            Changelog.Labeler l = new Changelog.Labeler();
            l.setLabel(JReleaserModelConverter.tr(labeler.getLabel()));
            l.setTitle(JReleaserModelConverter.tr(labeler.getTitle()));
            l.setBody(JReleaserModelConverter.tr(labeler.getBody()));
            l.setOrder(labeler.getOrder());
            set.add(l);
        }
        return set;
    }

    private static List<Changelog.Replacer> convertReplacers(List<Changelog.Replacer> replacers) {
        ArrayList<Changelog.Replacer> set = new ArrayList<Changelog.Replacer>();
        for (Changelog.Replacer replacer : replacers) {
            Changelog.Replacer r = new Changelog.Replacer();
            r.setSearch(JReleaserModelConverter.tr(replacer.getSearch()));
            r.setReplace(JReleaserModelConverter.tr(replacer.getReplace()));
            set.add(r);
        }
        return set;
    }

    private static org.jreleaser.model.Milestone convertMilestone(Milestone milestone) {
        org.jreleaser.model.Milestone m = new org.jreleaser.model.Milestone();
        m.setClose(milestone.isClose());
        if (StringUtils.isNotBlank((String)milestone.getName())) {
            m.setName(JReleaserModelConverter.tr(milestone.getName()));
        }
        return m;
    }

    private static org.jreleaser.model.Upload convertUpload(Upload upload) {
        org.jreleaser.model.Upload u = new org.jreleaser.model.Upload();
        if (upload.isEnabledSet()) {
            u.setEnabled(Boolean.valueOf(upload.isEnabled()));
        }
        u.setArtifactory(JReleaserModelConverter.convertArtifactory(upload.getArtifactory()));
        u.setHttp(JReleaserModelConverter.convertHttp(upload.getHttp()));
        u.setS3(JReleaserModelConverter.convertS3(upload.getS3()));
        return u;
    }

    private static Map<String, org.jreleaser.model.Artifactory> convertArtifactory(Map<String, Artifactory> artifactory) {
        LinkedHashMap<String, org.jreleaser.model.Artifactory> map = new LinkedHashMap<String, org.jreleaser.model.Artifactory>();
        for (Map.Entry<String, Artifactory> e : artifactory.entrySet()) {
            e.getValue().setName(JReleaserModelConverter.tr(e.getKey()));
            map.put(e.getValue().getName(), JReleaserModelConverter.convertArtifactory(e.getValue()));
        }
        return map;
    }

    private static org.jreleaser.model.Artifactory convertArtifactory(Artifactory artifactory) {
        org.jreleaser.model.Artifactory a = new org.jreleaser.model.Artifactory();
        JReleaserModelConverter.convertUploader(artifactory, (org.jreleaser.model.Uploader)a);
        if (StringUtils.isNotBlank((String)artifactory.getTarget())) {
            a.setTarget(artifactory.getTarget());
        }
        a.setUsername(JReleaserModelConverter.tr(artifactory.getUsername()));
        a.setPassword(JReleaserModelConverter.tr(artifactory.getPassword()));
        a.setAuthorization(JReleaserModelConverter.tr(artifactory.resolveAuthorization().name()));
        return a;
    }

    private static void convertUploader(Uploader from, org.jreleaser.model.Uploader into) {
        into.setName(JReleaserModelConverter.tr(from.getName()));
        into.setActive(from.resolveActive());
        into.setExtraProperties(from.getExtraProperties());
        into.setConnectTimeout(from.getConnectTimeout());
        into.setReadTimeout(from.getReadTimeout());
        if (from.isArtifactsSet()) {
            into.setArtifacts(from.isArtifacts());
        }
        if (from.isFilesSet()) {
            into.setFiles(from.isFiles());
        }
        if (from.isSignaturesSet()) {
            into.setSignatures(from.isSignatures());
        }
        if (from instanceof HttpUploader) {
            JReleaserModelConverter.convertHttpUploader((HttpUploader)from, (HttpUploader)into);
        }
    }

    private static void convertHttpUploader(HttpUploader from, HttpUploader into) {
        into.setUploadUrl(JReleaserModelConverter.tr(from.getUploadUrl()));
        into.setDownloadUrl(JReleaserModelConverter.tr(from.getDownloadUrl()));
    }

    private static Map<String, org.jreleaser.model.Http> convertHttp(Map<String, Http> http) {
        LinkedHashMap<String, org.jreleaser.model.Http> map = new LinkedHashMap<String, org.jreleaser.model.Http>();
        for (Map.Entry<String, Http> e : http.entrySet()) {
            e.getValue().setName(JReleaserModelConverter.tr(e.getKey()));
            map.put(e.getValue().getName(), JReleaserModelConverter.convertHttp(e.getValue()));
        }
        return map;
    }

    private static org.jreleaser.model.Http convertHttp(Http http) {
        org.jreleaser.model.Http h = new org.jreleaser.model.Http();
        JReleaserModelConverter.convertUploader(http, (org.jreleaser.model.Uploader)h);
        if (StringUtils.isNotBlank((String)http.getTarget())) {
            h.setTarget(http.getTarget());
        }
        h.setUsername(JReleaserModelConverter.tr(http.getUsername()));
        h.setPassword(JReleaserModelConverter.tr(http.getPassword()));
        h.setAuthorization(JReleaserModelConverter.tr(http.resolveAuthorization().name()));
        h.setMethod(JReleaserModelConverter.tr(http.resolveMethod().name()));
        h.setHeaders(http.getHeaders());
        return h;
    }

    private static Map<String, org.jreleaser.model.S3> convertS3(Map<String, S3> s3) {
        LinkedHashMap<String, org.jreleaser.model.S3> map = new LinkedHashMap<String, org.jreleaser.model.S3>();
        for (Map.Entry<String, S3> e : s3.entrySet()) {
            e.getValue().setName(JReleaserModelConverter.tr(e.getKey()));
            map.put(e.getValue().getName(), JReleaserModelConverter.convertS3(e.getValue()));
        }
        return map;
    }

    private static org.jreleaser.model.S3 convertS3(S3 s3) {
        org.jreleaser.model.S3 s = new org.jreleaser.model.S3();
        JReleaserModelConverter.convertUploader(s3, (org.jreleaser.model.Uploader)s);
        s.setRegion(JReleaserModelConverter.tr(s3.getRegion()));
        s.setBucket(JReleaserModelConverter.tr(s3.getBucket()));
        s.setAccessKeyId(JReleaserModelConverter.tr(s3.getAccessKeyId()));
        s.setSecretKey(JReleaserModelConverter.tr(s3.getSecretKey()));
        s.setSessionToken(JReleaserModelConverter.tr(s3.getSessionToken()));
        s.setEndpoint(JReleaserModelConverter.tr(s3.getEndpoint()));
        s.setPath(JReleaserModelConverter.tr(s3.getPath()));
        s.setDownloadUrl(JReleaserModelConverter.tr(s3.getDownloadUrl()));
        s.setHeaders(s3.getHeaders());
        return s;
    }

    private static org.jreleaser.model.Packagers convertPackagers(Packagers packagers) {
        org.jreleaser.model.Packagers p = new org.jreleaser.model.Packagers();
        if (packagers.getBrew().isSet()) {
            p.setBrew(JReleaserModelConverter.convertBrew(packagers.getBrew()));
        }
        if (packagers.getChocolatey().isSet()) {
            p.setChocolatey(JReleaserModelConverter.convertChocolatey(packagers.getChocolatey()));
        }
        if (packagers.getDocker().isSet()) {
            p.setDocker(JReleaserModelConverter.convertDocker(packagers.getDocker()));
        }
        if (packagers.getJbang().isSet()) {
            p.setJbang(JReleaserModelConverter.convertJbang(packagers.getJbang()));
        }
        if (packagers.getMacports().isSet()) {
            p.setMacports(JReleaserModelConverter.convertMacports(packagers.getMacports()));
        }
        if (packagers.getScoop().isSet()) {
            p.setScoop(JReleaserModelConverter.convertScoop(packagers.getScoop()));
        }
        if (packagers.getSdkman().isSet()) {
            p.setSdkman(JReleaserModelConverter.convertSdkman(packagers.getSdkman()));
        }
        if (packagers.getSnap().isSet()) {
            p.setSnap(JReleaserModelConverter.convertSnap(packagers.getSnap()));
        }
        if (packagers.getSpec().isSet()) {
            p.setSpec(JReleaserModelConverter.convertSpec(packagers.getSpec()));
        }
        return p;
    }

    private static org.jreleaser.model.Announce convertAnnounce(Announce announce) {
        org.jreleaser.model.Announce a = new org.jreleaser.model.Announce();
        if (announce.isEnabledSet()) {
            a.setEnabled(Boolean.valueOf(announce.isEnabled()));
        }
        if (announce.getArticle().isSet()) {
            a.setArticle(JReleaserModelConverter.convertArticle(announce.getArticle()));
        }
        if (announce.getDiscord().isSet()) {
            a.setDiscord(JReleaserModelConverter.convertDiscord(announce.getDiscord()));
        }
        if (announce.getDiscussions().isSet()) {
            a.setDiscussions(JReleaserModelConverter.convertDiscussions(announce.getDiscussions()));
        }
        if (announce.getGitter().isSet()) {
            a.setGitter(JReleaserModelConverter.convertGitter(announce.getGitter()));
        }
        if (announce.getGoogleChat().isSet()) {
            a.setGoogleChat(JReleaserModelConverter.convertGoogleChat(announce.getGoogleChat()));
        }
        if (announce.getMail().isSet()) {
            a.setMail(JReleaserModelConverter.convertMail(announce.getMail()));
        }
        if (announce.getMastodon().isSet()) {
            a.setMastodon(JReleaserModelConverter.convertMastodon(announce.getMastodon()));
        }
        if (announce.getMattermost().isSet()) {
            a.setMattermost(JReleaserModelConverter.convertMattermost(announce.getMattermost()));
        }
        if (announce.getSdkman().isSet()) {
            a.setSdkman(JReleaserModelConverter.convertSdkmanAnnouncer(announce.getSdkman()));
        }
        if (announce.getSlack().isSet()) {
            a.setSlack(JReleaserModelConverter.convertSlack(announce.getSlack()));
        }
        if (announce.getTeams().isSet()) {
            a.setTeams(JReleaserModelConverter.convertTeams(announce.getTeams()));
        }
        if (announce.getTelegram().isSet()) {
            a.setTelegram(JReleaserModelConverter.convertTelegram(announce.getTelegram()));
        }
        if (announce.getTwitter().isSet()) {
            a.setTwitter(JReleaserModelConverter.convertTwitter(announce.getTwitter()));
        }
        if (announce.getZulip().isSet()) {
            a.setZulip(JReleaserModelConverter.convertZulip(announce.getZulip()));
        }
        a.setWebhooks(JReleaserModelConverter.convertWebhooks(announce.getWebhooks()));
        return a;
    }

    private static org.jreleaser.model.Article convertArticle(Article article) {
        org.jreleaser.model.Article a = new org.jreleaser.model.Article();
        a.setActive(JReleaserModelConverter.tr(article.resolveActive()));
        a.setExtraProperties(article.getExtraProperties());
        a.setFiles(JReleaserModelConverter.convertArtifacts(article.getFiles()));
        a.setTemplateDirectory(JReleaserModelConverter.tr(article.getTemplateDirectory()));
        a.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(article.getCommitAuthor()));
        a.setRepository(JReleaserModelConverter.convertRepository(article.getRepository()));
        return a;
    }

    private static Repository convertRepository(Tap tap) {
        Repository t = new Repository();
        JReleaserModelConverter.convertTap(tap, (RepositoryTap)t);
        return t;
    }

    private static void convertTap(Tap from, RepositoryTap into) {
        into.setActive(JReleaserModelConverter.tr(from.resolveActive()));
        into.setOwner(JReleaserModelConverter.tr(from.getOwner()));
        into.setName(JReleaserModelConverter.tr(from.getName()));
        into.setBranch(JReleaserModelConverter.tr(from.getBranch()));
        into.setUsername(JReleaserModelConverter.tr(from.getUsername()));
        into.setToken(JReleaserModelConverter.tr(from.getToken()));
        into.setCommitMessage(JReleaserModelConverter.tr(from.getCommitMessage()));
    }

    private static void convertAnnouncer(Announcer from, org.jreleaser.model.Announcer into) {
        into.setActive(JReleaserModelConverter.tr(from.resolveActive()));
        into.setConnectTimeout(from.getConnectTimeout());
        into.setReadTimeout(from.getReadTimeout());
        into.setExtraProperties(from.getExtraProperties());
    }

    private static org.jreleaser.model.Discord convertDiscord(Discord discord) {
        org.jreleaser.model.Discord a = new org.jreleaser.model.Discord();
        JReleaserModelConverter.convertAnnouncer(discord, (org.jreleaser.model.Announcer)a);
        a.setWebhook(JReleaserModelConverter.tr(discord.getWebhook()));
        a.setMessage(JReleaserModelConverter.tr(discord.getMessage()));
        a.setMessageTemplate(JReleaserModelConverter.tr(discord.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.Discussions convertDiscussions(Discussions discussions) {
        org.jreleaser.model.Discussions a = new org.jreleaser.model.Discussions();
        JReleaserModelConverter.convertAnnouncer(discussions, (org.jreleaser.model.Announcer)a);
        a.setOrganization(JReleaserModelConverter.tr(discussions.getOrganization()));
        a.setTeam(JReleaserModelConverter.tr(discussions.getTeam()));
        a.setTitle(JReleaserModelConverter.tr(discussions.getTitle()));
        a.setMessage(JReleaserModelConverter.tr(discussions.getMessage()));
        a.setMessageTemplate(JReleaserModelConverter.tr(discussions.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.Gitter convertGitter(Gitter gitter) {
        org.jreleaser.model.Gitter a = new org.jreleaser.model.Gitter();
        JReleaserModelConverter.convertAnnouncer(gitter, (org.jreleaser.model.Announcer)a);
        a.setWebhook(JReleaserModelConverter.tr(gitter.getWebhook()));
        a.setMessage(JReleaserModelConverter.tr(gitter.getMessage()));
        a.setMessageTemplate(JReleaserModelConverter.tr(gitter.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.GoogleChat convertGoogleChat(GoogleChat googleChat) {
        org.jreleaser.model.GoogleChat a = new org.jreleaser.model.GoogleChat();
        JReleaserModelConverter.convertAnnouncer(googleChat, (org.jreleaser.model.Announcer)a);
        a.setWebhook(JReleaserModelConverter.tr(googleChat.getWebhook()));
        a.setMessage(JReleaserModelConverter.tr(googleChat.getMessage()));
        a.setMessageTemplate(JReleaserModelConverter.tr(googleChat.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.Mail convertMail(Mail mail) {
        org.jreleaser.model.Mail a = new org.jreleaser.model.Mail();
        JReleaserModelConverter.convertAnnouncer(mail, (org.jreleaser.model.Announcer)a);
        if (mail.isAuthSet()) {
            a.setAuth(mail.isAuth());
        }
        if (null != mail.getTransport()) {
            a.setTransport(mail.getTransport().name());
        }
        if (null != mail.getMimeType()) {
            a.setMimeType(mail.getMimeType().name());
        }
        a.setPort(mail.getPort());
        a.setUsername(JReleaserModelConverter.tr(mail.getUsername()));
        a.setPassword(JReleaserModelConverter.tr(mail.getPassword()));
        a.setFrom(JReleaserModelConverter.tr(mail.getFrom()));
        a.setTo(JReleaserModelConverter.tr(mail.getTo()));
        a.setCc(JReleaserModelConverter.tr(mail.getCc()));
        a.setBcc(JReleaserModelConverter.tr(mail.getBcc()));
        a.setSubject(JReleaserModelConverter.tr(mail.getSubject()));
        a.setMessage(JReleaserModelConverter.tr(mail.getMessage()));
        a.setMessageTemplate(JReleaserModelConverter.tr(mail.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.Mastodon convertMastodon(Mastodon mastodon) {
        org.jreleaser.model.Mastodon a = new org.jreleaser.model.Mastodon();
        JReleaserModelConverter.convertAnnouncer(mastodon, (org.jreleaser.model.Announcer)a);
        a.setHost(JReleaserModelConverter.tr(mastodon.getHost()));
        a.setAccessToken(JReleaserModelConverter.tr(mastodon.getAccessToken()));
        a.setStatus(JReleaserModelConverter.tr(mastodon.getStatus()));
        return a;
    }

    private static org.jreleaser.model.Mattermost convertMattermost(Mattermost mattermost) {
        org.jreleaser.model.Mattermost a = new org.jreleaser.model.Mattermost();
        JReleaserModelConverter.convertAnnouncer(mattermost, (org.jreleaser.model.Announcer)a);
        a.setWebhook(JReleaserModelConverter.tr(mattermost.getWebhook()));
        a.setMessage(JReleaserModelConverter.tr(mattermost.getMessage()));
        a.setMessageTemplate(JReleaserModelConverter.tr(mattermost.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.SdkmanAnnouncer convertSdkmanAnnouncer(SdkmanAnnouncer sdkman) {
        org.jreleaser.model.SdkmanAnnouncer a = new org.jreleaser.model.SdkmanAnnouncer();
        JReleaserModelConverter.convertAnnouncer(sdkman, (org.jreleaser.model.Announcer)a);
        a.setConsumerKey(JReleaserModelConverter.tr(sdkman.getConsumerKey()));
        a.setConsumerToken(JReleaserModelConverter.tr(sdkman.getConsumerToken()));
        a.setCandidate(JReleaserModelConverter.tr(sdkman.getCandidate()));
        a.setReleaseNotesUrl(JReleaserModelConverter.tr(sdkman.getReleaseNotesUrl()));
        a.setMajor(sdkman.isMajor());
        a.setCommand(sdkman.resolveCommand());
        return a;
    }

    private static org.jreleaser.model.Slack convertSlack(Slack slack) {
        org.jreleaser.model.Slack a = new org.jreleaser.model.Slack();
        JReleaserModelConverter.convertAnnouncer(slack, (org.jreleaser.model.Announcer)a);
        a.setToken(JReleaserModelConverter.tr(slack.getToken()));
        a.setWebhook(JReleaserModelConverter.tr(slack.getWebhook()));
        a.setChannel(JReleaserModelConverter.tr(slack.getChannel()));
        a.setMessage(JReleaserModelConverter.tr(slack.getMessage()));
        a.setMessageTemplate(JReleaserModelConverter.tr(slack.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.Teams convertTeams(Teams teams) {
        org.jreleaser.model.Teams a = new org.jreleaser.model.Teams();
        JReleaserModelConverter.convertAnnouncer(teams, (org.jreleaser.model.Announcer)a);
        a.setWebhook(JReleaserModelConverter.tr(teams.getWebhook()));
        a.setMessageTemplate(JReleaserModelConverter.tr(teams.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.Telegram convertTelegram(Telegram telegram) {
        org.jreleaser.model.Telegram a = new org.jreleaser.model.Telegram();
        JReleaserModelConverter.convertAnnouncer(telegram, (org.jreleaser.model.Announcer)a);
        a.setToken(JReleaserModelConverter.tr(telegram.getToken()));
        a.setChatId(JReleaserModelConverter.tr(telegram.getChatId()));
        a.setMessage(JReleaserModelConverter.tr(telegram.getMessage()));
        a.setMessageTemplate(JReleaserModelConverter.tr(telegram.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.Twitter convertTwitter(Twitter twitter) {
        org.jreleaser.model.Twitter a = new org.jreleaser.model.Twitter();
        JReleaserModelConverter.convertAnnouncer(twitter, (org.jreleaser.model.Announcer)a);
        a.setConsumerKey(JReleaserModelConverter.tr(twitter.getConsumerKey()));
        a.setConsumerSecret(JReleaserModelConverter.tr(twitter.getConsumerSecret()));
        a.setAccessToken(JReleaserModelConverter.tr(twitter.getAccessToken()));
        a.setAccessTokenSecret(JReleaserModelConverter.tr(twitter.getAccessTokenSecret()));
        a.setStatus(JReleaserModelConverter.tr(twitter.getStatus()));
        return a;
    }

    private static org.jreleaser.model.Zulip convertZulip(Zulip zulip) {
        org.jreleaser.model.Zulip a = new org.jreleaser.model.Zulip();
        JReleaserModelConverter.convertAnnouncer(zulip, (org.jreleaser.model.Announcer)a);
        a.setAccount(JReleaserModelConverter.tr(zulip.getAccount()));
        a.setApiKey(JReleaserModelConverter.tr(zulip.getApiKey()));
        a.setApiHost(JReleaserModelConverter.tr(zulip.getApiHost()));
        a.setChannel(JReleaserModelConverter.tr(zulip.getChannel()));
        a.setSubject(JReleaserModelConverter.tr(zulip.getSubject()));
        a.setMessage(JReleaserModelConverter.tr(zulip.getMessage()));
        a.setMessageTemplate(JReleaserModelConverter.tr(zulip.getMessageTemplate()));
        return a;
    }

    private static Map<String, org.jreleaser.model.Webhook> convertWebhooks(Map<String, Webhook> webhooks) {
        LinkedHashMap<String, org.jreleaser.model.Webhook> ds = new LinkedHashMap<String, org.jreleaser.model.Webhook>();
        for (Map.Entry<String, Webhook> e : webhooks.entrySet()) {
            e.getValue().setName(JReleaserModelConverter.tr(e.getKey()));
            ds.put(e.getValue().getName(), JReleaserModelConverter.convertWebhook(e.getValue()));
        }
        return ds;
    }

    private static org.jreleaser.model.Webhook convertWebhook(Webhook webhook) {
        org.jreleaser.model.Webhook a = new org.jreleaser.model.Webhook();
        JReleaserModelConverter.convertAnnouncer(webhook, (org.jreleaser.model.Announcer)a);
        a.setWebhook(JReleaserModelConverter.tr(webhook.getWebhook()));
        a.setMessage(JReleaserModelConverter.tr(webhook.getMessage()));
        a.setMessageProperty(JReleaserModelConverter.tr(webhook.getMessageProperty()));
        a.setMessageTemplate(JReleaserModelConverter.tr(webhook.getMessageTemplate()));
        return a;
    }

    private static org.jreleaser.model.Assemble convertAssemble(Assemble assemble) {
        org.jreleaser.model.Assemble a = new org.jreleaser.model.Assemble();
        if (assemble.isEnabledSet()) {
            a.setEnabled(Boolean.valueOf(assemble.isEnabled()));
        }
        a.setArchive(JReleaserModelConverter.convertArchive(assemble.getArchive()));
        a.setJlink(JReleaserModelConverter.convertJlink(assemble.getJlink()));
        a.setNativeImage(JReleaserModelConverter.convertNativeImage(assemble.getNativeImage()));
        return a;
    }

    private static Map<String, org.jreleaser.model.Archive> convertArchive(Map<String, Archive> archive) {
        LinkedHashMap<String, org.jreleaser.model.Archive> map = new LinkedHashMap<String, org.jreleaser.model.Archive>();
        for (Map.Entry<String, Archive> e : archive.entrySet()) {
            e.getValue().setName(JReleaserModelConverter.tr(e.getKey()));
            map.put(e.getValue().getName(), JReleaserModelConverter.convertArchive(e.getValue()));
        }
        return map;
    }

    private static org.jreleaser.model.Archive convertArchive(Archive archive) {
        org.jreleaser.model.Archive a = new org.jreleaser.model.Archive();
        a.setExported(archive.isExported());
        a.setName(JReleaserModelConverter.tr(archive.getName()));
        a.setActive(JReleaserModelConverter.tr(archive.resolveActive()));
        a.setExtraProperties(archive.getExtraProperties());
        a.setArchiveName(JReleaserModelConverter.tr(archive.getArchiveName()));
        a.setDistributionType(JReleaserModelConverter.tr(archive.getDistributionType().name()));
        if (archive.isAttachPlatformSet()) {
            a.setAttachPlatform(Boolean.valueOf(archive.isAttachPlatform()));
        }
        a.setFormats(archive.getFormats().stream().map(Object::toString).map(Archive.Format::valueOf).collect(Collectors.toSet()));
        a.setFileSets(JReleaserModelConverter.convertFileSets(archive.getFileSets()));
        return a;
    }

    private static List<org.jreleaser.model.FileSet> convertFileSets(List<FileSet> fileSets) {
        return fileSets.stream().map(JReleaserModelConverter::convertFileSet).collect(Collectors.toList());
    }

    private static org.jreleaser.model.FileSet convertFileSet(FileSet fileSet) {
        org.jreleaser.model.FileSet f = new org.jreleaser.model.FileSet();
        f.setInput(JReleaserModelConverter.tr(fileSet.getInput()));
        f.setOutput(JReleaserModelConverter.tr(fileSet.getOutput()));
        f.setIncludes(JReleaserModelConverter.tr(fileSet.getIncludes()));
        f.setExcludes(JReleaserModelConverter.tr(fileSet.getExcludes()));
        f.setExtraProperties(fileSet.getExtraProperties());
        return f;
    }

    private static Map<String, org.jreleaser.model.Jlink> convertJlink(Map<String, Jlink> jlink) {
        LinkedHashMap<String, org.jreleaser.model.Jlink> map = new LinkedHashMap<String, org.jreleaser.model.Jlink>();
        for (Map.Entry<String, Jlink> e : jlink.entrySet()) {
            e.getValue().setName(JReleaserModelConverter.tr(e.getKey()));
            map.put(e.getValue().getName(), JReleaserModelConverter.convertJlink(e.getValue()));
        }
        return map;
    }

    private static org.jreleaser.model.Jlink convertJlink(Jlink jlink) {
        org.jreleaser.model.Jlink a = new org.jreleaser.model.Jlink();
        a.setExported(jlink.isExported());
        a.setName(JReleaserModelConverter.tr(jlink.getName()));
        a.setActive(JReleaserModelConverter.tr(jlink.resolveActive()));
        a.setJava(JReleaserModelConverter.convertJava(jlink.getJava()));
        a.setExecutable(JReleaserModelConverter.tr(jlink.getExecutable()));
        a.setExtraProperties(jlink.getExtraProperties());
        a.setTemplateDirectory(JReleaserModelConverter.tr(jlink.getTemplateDirectory()));
        a.setTargetJdks(JReleaserModelConverter.convertArtifacts(jlink.getTargetJdks()));
        a.setModuleNames(JReleaserModelConverter.tr(jlink.getModuleNames()));
        a.setAdditionalModuleNames(JReleaserModelConverter.tr(jlink.getAdditionalModuleNames()));
        a.setArgs(JReleaserModelConverter.tr(jlink.getArgs()));
        a.setJdeps(JReleaserModelConverter.convertJdeps(jlink.getJdeps()));
        a.setJdk(JReleaserModelConverter.convertArtifact(jlink.getJdk()));
        a.setMainJar(JReleaserModelConverter.convertArtifact(jlink.getMainJar()));
        a.setImageName(JReleaserModelConverter.tr(jlink.getImageName()));
        a.setImageNameTransform(JReleaserModelConverter.tr(jlink.getImageNameTransform()));
        a.setModuleName(JReleaserModelConverter.tr(jlink.getModuleName()));
        if (jlink.isCopyJarsSet()) {
            a.setCopyJars(jlink.isCopyJars());
        }
        a.setJars(JReleaserModelConverter.convertGlobs(jlink.getJars()));
        a.setFiles(JReleaserModelConverter.convertGlobs(jlink.getFiles()));
        a.setFileSets(JReleaserModelConverter.convertFileSets(jlink.getFileSets()));
        return a;
    }

    private static org.jreleaser.model.Jdeps convertJdeps(Jdeps jdeps) {
        org.jreleaser.model.Jdeps j = new org.jreleaser.model.Jdeps();
        j.setMultiRelease(jdeps.getMultiRelease());
        if (jdeps.isIgnoreMissingDepsSet()) {
            j.setIgnoreMissingDeps(jdeps.isIgnoreMissingDeps());
        }
        return j;
    }

    private static Map<String, org.jreleaser.model.NativeImage> convertNativeImage(Map<String, NativeImage> nativeImage) {
        LinkedHashMap<String, org.jreleaser.model.NativeImage> map = new LinkedHashMap<String, org.jreleaser.model.NativeImage>();
        for (Map.Entry<String, NativeImage> e : nativeImage.entrySet()) {
            e.getValue().setName(JReleaserModelConverter.tr(e.getKey()));
            map.put(e.getValue().getName(), JReleaserModelConverter.convertNativeImage(e.getValue()));
        }
        return map;
    }

    private static org.jreleaser.model.NativeImage convertNativeImage(NativeImage nativeImage) {
        org.jreleaser.model.NativeImage a = new org.jreleaser.model.NativeImage();
        a.setExported(nativeImage.isExported());
        a.setName(JReleaserModelConverter.tr(nativeImage.getName()));
        a.setActive(JReleaserModelConverter.tr(nativeImage.resolveActive()));
        a.setJava(JReleaserModelConverter.convertJava(nativeImage.getJava()));
        a.setExecutable(JReleaserModelConverter.tr(nativeImage.getExecutable()));
        a.setExtraProperties(nativeImage.getExtraProperties());
        a.setTemplateDirectory(JReleaserModelConverter.tr(nativeImage.getTemplateDirectory()));
        a.setGraal(JReleaserModelConverter.convertArtifact(nativeImage.getGraal()));
        a.setMainJar(JReleaserModelConverter.convertArtifact(nativeImage.getMainJar()));
        a.setImageName(JReleaserModelConverter.tr(nativeImage.getImageName()));
        a.setImageNameTransform(JReleaserModelConverter.tr(nativeImage.getImageNameTransform()));
        a.setJars(JReleaserModelConverter.convertGlobs(nativeImage.getJars()));
        a.setFiles(JReleaserModelConverter.convertGlobs(nativeImage.getFiles()));
        a.setFileSets(JReleaserModelConverter.convertFileSets(nativeImage.getFileSets()));
        a.setArgs(JReleaserModelConverter.tr(nativeImage.getArgs()));
        return a;
    }

    private static org.jreleaser.model.Checksum convertChecksum(Checksum checksum) {
        org.jreleaser.model.Checksum s = new org.jreleaser.model.Checksum();
        s.setName(JReleaserModelConverter.tr(checksum.getName()));
        s.setIndividual(checksum.isIndividual());
        s.setAlgorithms(checksum.getAlgorithms());
        if (checksum.isFilesSet()) {
            s.setFiles(checksum.isFiles());
        }
        return s;
    }

    private static org.jreleaser.model.Signing convertSigning(Signing signing) {
        org.jreleaser.model.Signing s = new org.jreleaser.model.Signing();
        s.setActive(JReleaserModelConverter.tr(signing.resolveActive()));
        s.setArmored(Boolean.valueOf(signing.isArmored()));
        s.setPublicKey(JReleaserModelConverter.tr(signing.getPublicKey()));
        s.setSecretKey(JReleaserModelConverter.tr(signing.getSecretKey()));
        s.setPassphrase(JReleaserModelConverter.tr(signing.getPassphrase()));
        s.setMode(JReleaserModelConverter.tr(signing.resolveMode()));
        if (signing.isArtifactsSet()) {
            s.setArtifacts(signing.isArtifacts());
        }
        if (signing.isFilesSet()) {
            s.setFiles(signing.isFiles());
        }
        if (signing.isChecksumsSet()) {
            s.setChecksums(signing.isChecksums());
        }
        if (signing.isDefaultKeyringSet()) {
            s.setDefaultKeyring(signing.isDefaultKeyring());
        }
        s.setExecutable(JReleaserModelConverter.tr(signing.getExecutable()));
        s.setKeyName(JReleaserModelConverter.tr(signing.getKeyName()));
        s.setHomeDir(JReleaserModelConverter.tr(signing.getHomeDir()));
        s.setPublicKeyring(JReleaserModelConverter.tr(signing.getPublicKeyring()));
        s.setArgs(JReleaserModelConverter.tr(signing.getArgs()));
        return s;
    }

    private static Map<String, org.jreleaser.model.Distribution> convertDistributions(Map<String, Distribution> distributions) {
        LinkedHashMap<String, org.jreleaser.model.Distribution> ds = new LinkedHashMap<String, org.jreleaser.model.Distribution>();
        for (Map.Entry<String, Distribution> e : distributions.entrySet()) {
            e.getValue().setName(JReleaserModelConverter.tr(e.getKey()));
            ds.put(e.getValue().getName(), JReleaserModelConverter.convertDistribution(e.getValue()));
        }
        return ds;
    }

    private static org.jreleaser.model.Distribution convertDistribution(Distribution distribution) {
        org.jreleaser.model.Distribution d = new org.jreleaser.model.Distribution();
        d.setActive(JReleaserModelConverter.tr(distribution.resolveActive()));
        d.setName(JReleaserModelConverter.tr(distribution.getName()));
        d.setType(JReleaserModelConverter.tr(distribution.getType().name()));
        d.setExecutable(JReleaserModelConverter.tr(distribution.getExecutable()));
        d.setExecutableExtension(JReleaserModelConverter.tr(distribution.getExecutableExtension()));
        d.setJava(JReleaserModelConverter.convertJava(distribution.getJava()));
        d.setTags(JReleaserModelConverter.tr(distribution.getTags()));
        d.setExtraProperties(distribution.getExtraProperties());
        d.setArtifacts(JReleaserModelConverter.convertArtifacts(distribution.getArtifacts()));
        if (distribution.getBrew().isSet()) {
            d.setBrew(JReleaserModelConverter.convertBrew(distribution.getBrew()));
        }
        if (distribution.getChocolatey().isSet()) {
            d.setChocolatey(JReleaserModelConverter.convertChocolatey(distribution.getChocolatey()));
        }
        if (distribution.getDocker().isSet()) {
            d.setDocker(JReleaserModelConverter.convertDocker(distribution.getDocker()));
        }
        if (distribution.getJbang().isSet()) {
            d.setJbang(JReleaserModelConverter.convertJbang(distribution.getJbang()));
        }
        if (distribution.getMacports().isSet()) {
            d.setMacports(JReleaserModelConverter.convertMacports(distribution.getMacports()));
        }
        if (distribution.getScoop().isSet()) {
            d.setScoop(JReleaserModelConverter.convertScoop(distribution.getScoop()));
        }
        if (distribution.getSnap().isSet()) {
            d.setSnap(JReleaserModelConverter.convertSnap(distribution.getSnap()));
        }
        if (distribution.getSpec().isSet()) {
            d.setSpec(JReleaserModelConverter.convertSpec(distribution.getSpec()));
        }
        return d;
    }

    private static org.jreleaser.model.Files convertFiles(Files files) {
        org.jreleaser.model.Files fs = new org.jreleaser.model.Files();
        fs.setArtifacts(JReleaserModelConverter.convertArtifacts(files.getArtifacts()));
        fs.setGlobs(JReleaserModelConverter.convertGlobs(files.getGlobs()));
        return fs;
    }

    private static Set<org.jreleaser.model.Artifact> convertArtifacts(Set<Artifact> artifacts) {
        LinkedHashSet<org.jreleaser.model.Artifact> as = new LinkedHashSet<org.jreleaser.model.Artifact>();
        for (Artifact artifact : artifacts) {
            as.add(JReleaserModelConverter.convertArtifact(artifact));
        }
        return as;
    }

    private static org.jreleaser.model.Artifact convertArtifact(Artifact artifact) {
        org.jreleaser.model.Artifact a = new org.jreleaser.model.Artifact();
        a.setPath(JReleaserModelConverter.tr(artifact.getPath()));
        a.setTransform(JReleaserModelConverter.tr(artifact.getTransform()));
        a.setPlatform(JReleaserModelConverter.tr(artifact.getPlatform()));
        a.setExtraProperties(artifact.getExtraProperties());
        return a;
    }

    private static List<org.jreleaser.model.Glob> convertGlobs(List<Glob> globs) {
        ArrayList<org.jreleaser.model.Glob> gs = new ArrayList<org.jreleaser.model.Glob>();
        for (Glob glob : globs) {
            gs.add(JReleaserModelConverter.convertGlob(glob));
        }
        return gs;
    }

    private static org.jreleaser.model.Glob convertGlob(Glob glob) {
        org.jreleaser.model.Glob g = new org.jreleaser.model.Glob();
        g.setPattern(JReleaserModelConverter.tr(glob.getPattern()));
        g.setPlatform(JReleaserModelConverter.tr(glob.getPlatform()));
        if (StringUtils.isNotBlank((String)glob.getDirectory())) {
            g.setDirectory(JReleaserModelConverter.tr(glob.getDirectory()));
        }
        if (StringUtils.isNotBlank((String)glob.getInclude())) {
            g.setInclude(glob.getInclude());
        }
        if (StringUtils.isNotBlank((String)glob.getExclude())) {
            g.setExclude(glob.getExclude());
        }
        if (glob.isRecursiveSet()) {
            g.setRecursive(glob.isRecursive());
        }
        return g;
    }

    private static org.jreleaser.model.Brew convertBrew(Brew tool) {
        org.jreleaser.model.Brew t = new org.jreleaser.model.Brew();
        t.setActive(JReleaserModelConverter.tr(tool.resolveActive()));
        t.setTemplateDirectory(JReleaserModelConverter.tr(tool.getTemplateDirectory()));
        if (tool.isContinueOnErrorSet()) {
            t.setContinueOnError(Boolean.valueOf(tool.isContinueOnError()));
        }
        t.setExtraProperties(tool.getExtraProperties());
        t.setTap(JReleaserModelConverter.convertHomebrewTap(tool.getTap()));
        t.setFormulaName(JReleaserModelConverter.tr(tool.getFormulaName()));
        if (tool.isMultiPlatformSet()) {
            t.setMultiPlatform(Boolean.valueOf(tool.isMultiPlatform()));
        }
        t.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(tool.getCommitAuthor()));
        tool.getDependencies().forEach(dependency -> {
            if (StringUtils.isNotBlank((String)dependency.getValue())) {
                t.addDependency(dependency.getKey(), dependency.getValue());
            } else {
                t.addDependency(dependency.getKey());
            }
        });
        t.setLivecheck(JReleaserModelConverter.tr(tool.getLivecheck()));
        if (tool.getCask().isSet()) {
            t.setCask(JReleaserModelConverter.convertCask(tool.getCask()));
        }
        return t;
    }

    private static org.jreleaser.model.Cask convertCask(Cask cask) {
        org.jreleaser.model.Cask c = new org.jreleaser.model.Cask();
        c.setName(JReleaserModelConverter.tr(cask.getName()));
        c.setDisplayName(JReleaserModelConverter.tr(cask.getDisplayName()));
        c.setPkgName(JReleaserModelConverter.tr(cask.getPkgName()));
        c.setAppName(JReleaserModelConverter.tr(cask.getAppName()));
        c.setAppcast(JReleaserModelConverter.tr(cask.getAppcast()));
        if (cask.isEnabledSet()) {
            c.setEnabled(cask.isEnabled());
        }
        c.setUninstall(cask.getUninstall());
        c.setZap(cask.getZap());
        return c;
    }

    private static HomebrewTap convertHomebrewTap(Tap tap) {
        HomebrewTap t = new HomebrewTap();
        JReleaserModelConverter.convertTap(tap, (RepositoryTap)t);
        return t;
    }

    private static org.jreleaser.model.Chocolatey convertChocolatey(Chocolatey tool) {
        org.jreleaser.model.Chocolatey t = new org.jreleaser.model.Chocolatey();
        t.setActive(JReleaserModelConverter.tr(tool.resolveActive()));
        if (tool.isContinueOnErrorSet()) {
            t.setContinueOnError(Boolean.valueOf(tool.isContinueOnError()));
        }
        t.setUsername(JReleaserModelConverter.tr(tool.getUsername()));
        t.setApiKey(JReleaserModelConverter.tr(tool.getApiKey()));
        t.setTitle(JReleaserModelConverter.tr(tool.getTitle()));
        t.setRemoteBuild(Boolean.valueOf(tool.isRemoteBuild()));
        t.setTemplateDirectory(JReleaserModelConverter.tr(tool.getTemplateDirectory()));
        t.setExtraProperties(tool.getExtraProperties());
        t.setBucket(JReleaserModelConverter.convertChocolateyBucket(tool.getBucket()));
        t.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(tool.getCommitAuthor()));
        return t;
    }

    private static org.jreleaser.model.Docker convertDocker(Docker docker) {
        org.jreleaser.model.Docker t = new org.jreleaser.model.Docker();
        JReleaserModelConverter.convertDocker((org.jreleaser.model.DockerConfiguration)t, docker);
        t.setSpecs(JReleaserModelConverter.convertDockerSpecs(docker.getSpecs()));
        return t;
    }

    private static void convertDocker(org.jreleaser.model.DockerConfiguration d, DockerConfiguration docker) {
        if (d instanceof org.jreleaser.model.Docker && docker instanceof Docker) {
            org.jreleaser.model.Docker dd = (org.jreleaser.model.Docker)d;
            Docker kk = (Docker)docker;
            if (kk.isContinueOnErrorSet()) {
                dd.setContinueOnError(Boolean.valueOf(kk.isContinueOnError()));
            }
            dd.setRepository(JReleaserModelConverter.convertDockerRepository(kk.getRepository()));
            dd.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(kk.getCommitAuthor()));
        }
        d.setActive(JReleaserModelConverter.tr(docker.resolveActive()));
        d.setTemplateDirectory(JReleaserModelConverter.tr(docker.getTemplateDirectory()));
        d.setExtraProperties(docker.getExtraProperties());
        d.setBaseImage(JReleaserModelConverter.tr(docker.getBaseImage()));
        d.setImageNames(JReleaserModelConverter.tr(docker.getImageNames()));
        d.setBuildArgs(JReleaserModelConverter.tr(docker.getBuildArgs()));
        d.setPreCommands(JReleaserModelConverter.tr(docker.getPreCommands()));
        d.setPostCommands(JReleaserModelConverter.tr(docker.getPostCommands()));
        d.setLabels(docker.getLabels());
        d.setRegistries(JReleaserModelConverter.convertRegistries(docker.getRegistries()));
        if (docker.isUseLocalArtifactSet()) {
            d.setUseLocalArtifact(Boolean.valueOf(docker.isUseLocalArtifact()));
        }
    }

    private static org.jreleaser.model.DockerRepository convertDockerRepository(DockerRepository tap) {
        org.jreleaser.model.DockerRepository t = new org.jreleaser.model.DockerRepository();
        JReleaserModelConverter.convertTap(tap, (RepositoryTap)t);
        if (tap.isVersionedSubfoldersSet()) {
            t.setVersionedSubfolders(Boolean.valueOf(tap.isVersionedSubfolders()));
        }
        return t;
    }

    private static Map<String, org.jreleaser.model.DockerSpec> convertDockerSpecs(List<DockerSpec> specs) {
        LinkedHashMap<String, org.jreleaser.model.DockerSpec> ds = new LinkedHashMap<String, org.jreleaser.model.DockerSpec>();
        for (DockerSpec spec : specs) {
            ds.put(spec.getName(), JReleaserModelConverter.convertDockerSpec(spec));
        }
        return ds;
    }

    private static org.jreleaser.model.DockerSpec convertDockerSpec(DockerSpec spec) {
        org.jreleaser.model.DockerSpec d = new org.jreleaser.model.DockerSpec();
        JReleaserModelConverter.convertDocker((org.jreleaser.model.DockerConfiguration)d, spec);
        d.setMatchers(spec.getMatchers());
        return d;
    }

    private static Set<org.jreleaser.model.Registry> convertRegistries(Set<Registry> repositories) {
        LinkedHashSet<org.jreleaser.model.Registry> set = new LinkedHashSet<org.jreleaser.model.Registry>();
        for (Registry registry : repositories) {
            set.add(JReleaserModelConverter.convertRegistry(registry));
        }
        return set;
    }

    private static org.jreleaser.model.Registry convertRegistry(Registry registry) {
        org.jreleaser.model.Registry r = new org.jreleaser.model.Registry();
        if (StringUtils.isNotBlank((String)registry.getServerName())) {
            r.setServerName(registry.getServerName());
        }
        r.setServer(JReleaserModelConverter.tr(registry.getServer()));
        r.setRepositoryName(JReleaserModelConverter.tr(registry.getRepositoryName()));
        r.setUsername(JReleaserModelConverter.tr(registry.getUsername()));
        r.setPassword(JReleaserModelConverter.tr(registry.getPassword()));
        return r;
    }

    private static ChocolateyBucket convertChocolateyBucket(Bucket bucket) {
        ChocolateyBucket b = new ChocolateyBucket();
        JReleaserModelConverter.convertTap(bucket, (RepositoryTap)b);
        return b;
    }

    private static org.jreleaser.model.Jbang convertJbang(Jbang tool) {
        org.jreleaser.model.Jbang t = new org.jreleaser.model.Jbang();
        t.setActive(JReleaserModelConverter.tr(tool.resolveActive()));
        if (tool.isContinueOnErrorSet()) {
            t.setContinueOnError(Boolean.valueOf(tool.isContinueOnError()));
        }
        t.setTemplateDirectory(JReleaserModelConverter.tr(tool.getTemplateDirectory()));
        t.setExtraProperties(tool.getExtraProperties());
        t.setAlias(JReleaserModelConverter.tr(tool.getAlias()));
        t.setCatalog(JReleaserModelConverter.convertJbangCatalog(tool.getCatalog()));
        t.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(tool.getCommitAuthor()));
        return t;
    }

    private static JbangCatalog convertJbangCatalog(Catalog catalog) {
        JbangCatalog t = new JbangCatalog();
        JReleaserModelConverter.convertTap(catalog, (RepositoryTap)t);
        return t;
    }

    private static org.jreleaser.model.Macports convertMacports(Macports tool) {
        org.jreleaser.model.Macports t = new org.jreleaser.model.Macports();
        t.setActive(JReleaserModelConverter.tr(tool.resolveActive()));
        if (tool.isContinueOnErrorSet()) {
            t.setContinueOnError(Boolean.valueOf(tool.isContinueOnError()));
        }
        t.setTemplateDirectory(JReleaserModelConverter.tr(tool.getTemplateDirectory()));
        t.setExtraProperties(tool.getExtraProperties());
        t.setRevision(tool.getRevision());
        t.setCategories(JReleaserModelConverter.tr(tool.getCategories()));
        t.setMaintainers(JReleaserModelConverter.tr(tool.getMaintainers()));
        t.setRepository(JReleaserModelConverter.convertMacportsRepository(tool.getRepository()));
        t.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(tool.getCommitAuthor()));
        return t;
    }

    private static MacportsRepository convertMacportsRepository(Tap tap) {
        MacportsRepository r = new MacportsRepository();
        JReleaserModelConverter.convertTap(tap, (RepositoryTap)r);
        return r;
    }

    private static org.jreleaser.model.Scoop convertScoop(Scoop tool) {
        org.jreleaser.model.Scoop t = new org.jreleaser.model.Scoop();
        t.setActive(JReleaserModelConverter.tr(tool.resolveActive()));
        if (tool.isContinueOnErrorSet()) {
            t.setContinueOnError(Boolean.valueOf(tool.isContinueOnError()));
        }
        t.setTemplateDirectory(JReleaserModelConverter.tr(tool.getTemplateDirectory()));
        t.setExtraProperties(tool.getExtraProperties());
        t.setCheckverUrl(JReleaserModelConverter.tr(tool.getCheckverUrl()));
        t.setAutoupdateUrl(JReleaserModelConverter.tr(tool.getAutoupdateUrl()));
        t.setBucket(JReleaserModelConverter.convertScoopBucket(tool.getBucket()));
        t.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(tool.getCommitAuthor()));
        return t;
    }

    private static ScoopBucket convertScoopBucket(Bucket bucket) {
        ScoopBucket b = new ScoopBucket();
        JReleaserModelConverter.convertTap(bucket, (RepositoryTap)b);
        return b;
    }

    private static org.jreleaser.model.Sdkman convertSdkman(Sdkman tool) {
        org.jreleaser.model.Sdkman t = new org.jreleaser.model.Sdkman();
        t.setActive(JReleaserModelConverter.tr(tool.resolveActive()));
        if (tool.isContinueOnErrorSet()) {
            t.setContinueOnError(Boolean.valueOf(tool.isContinueOnError()));
        }
        t.setExtraProperties(tool.getExtraProperties());
        t.setConsumerKey(JReleaserModelConverter.tr(tool.getConsumerKey()));
        t.setConsumerToken(JReleaserModelConverter.tr(tool.getConsumerToken()));
        t.setCandidate(JReleaserModelConverter.tr(tool.getCandidate()));
        t.setCommand(JReleaserModelConverter.tr(tool.resolveCommand()));
        t.setConnectTimeout(tool.getConnectTimeout());
        t.setReadTimeout(tool.getReadTimeout());
        return t;
    }

    private static org.jreleaser.model.Snap convertSnap(Snap tool) {
        org.jreleaser.model.Snap t = new org.jreleaser.model.Snap();
        t.setActive(JReleaserModelConverter.tr(tool.resolveActive()));
        if (tool.isContinueOnErrorSet()) {
            t.setContinueOnError(Boolean.valueOf(tool.isContinueOnError()));
        }
        t.setTemplateDirectory(JReleaserModelConverter.tr(tool.getTemplateDirectory()));
        t.setExtraProperties(tool.getExtraProperties());
        if (StringUtils.isNotBlank((String)tool.getBase())) {
            t.setBase(tool.getBase());
        }
        if (StringUtils.isNotBlank((String)tool.getGrade())) {
            t.setGrade(tool.getGrade());
        }
        if (StringUtils.isNotBlank((String)tool.getConfinement())) {
            t.setConfinement(tool.getConfinement());
        }
        if (null != tool.getExportedLogin()) {
            t.setExportedLogin(tool.getExportedLogin().getAbsolutePath());
        }
        t.setRemoteBuild(Boolean.valueOf(tool.isRemoteBuild()));
        t.setLocalPlugs(tool.getLocalPlugs());
        t.setLocalSlots(tool.getLocalSlots());
        t.setPlugs(JReleaserModelConverter.convertPlugs(tool.getPlugs()));
        t.setSlots(JReleaserModelConverter.convertSlots(tool.getSlots()));
        t.setSnap(JReleaserModelConverter.convertSnapTap(tool.getSnap()));
        t.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(tool.getCommitAuthor()));
        return t;
    }

    private static SnapTap convertSnapTap(Tap tap) {
        SnapTap t = new SnapTap();
        JReleaserModelConverter.convertTap(tap, (RepositoryTap)t);
        return t;
    }

    private static List<org.jreleaser.model.Plug> convertPlugs(List<Plug> plugs) {
        ArrayList<org.jreleaser.model.Plug> ps = new ArrayList<org.jreleaser.model.Plug>();
        for (Plug plug : plugs) {
            ps.add(JReleaserModelConverter.convertArtifact(plug));
        }
        return ps;
    }

    private static org.jreleaser.model.Plug convertArtifact(Plug plug) {
        org.jreleaser.model.Plug p = new org.jreleaser.model.Plug();
        p.setName(JReleaserModelConverter.tr(plug.getName()));
        p.setAttributes(plug.getAttributes());
        return p;
    }

    private static List<org.jreleaser.model.Slot> convertSlots(List<Slot> slots) {
        ArrayList<org.jreleaser.model.Slot> ps = new ArrayList<org.jreleaser.model.Slot>();
        for (Slot slot : slots) {
            ps.add(JReleaserModelConverter.convertSlot(slot));
        }
        return ps;
    }

    private static org.jreleaser.model.Slot convertSlot(Slot slot) {
        org.jreleaser.model.Slot p = new org.jreleaser.model.Slot();
        p.setName(JReleaserModelConverter.tr(slot.getName()));
        p.setAttributes(slot.getAttributes());
        p.setReads(JReleaserModelConverter.tr(slot.getReads()));
        p.setWrites(JReleaserModelConverter.tr(slot.getWrites()));
        return p;
    }

    private static org.jreleaser.model.Spec convertSpec(Spec tool) {
        org.jreleaser.model.Spec t = new org.jreleaser.model.Spec();
        t.setActive(JReleaserModelConverter.tr(tool.resolveActive()));
        if (tool.isContinueOnErrorSet()) {
            t.setContinueOnError(Boolean.valueOf(tool.isContinueOnError()));
        }
        t.setTemplateDirectory(JReleaserModelConverter.tr(tool.getTemplateDirectory()));
        t.setExtraProperties(tool.getExtraProperties());
        t.setRelease(JReleaserModelConverter.tr(tool.getRelease()));
        t.setRequires(JReleaserModelConverter.tr(tool.getRequires()));
        t.setRepository(JReleaserModelConverter.convertSpecRepository(tool.getRepository()));
        t.setCommitAuthor(JReleaserModelConverter.convertCommitAuthor(tool.getCommitAuthor()));
        return t;
    }

    private static SpecRepository convertSpecRepository(Tap tap) {
        SpecRepository r = new SpecRepository();
        JReleaserModelConverter.convertTap(tap, (RepositoryTap)r);
        return r;
    }
}

