/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.maven.plugin.Active;
import org.jreleaser.maven.plugin.Artifact;
import org.jreleaser.maven.plugin.Assembler;
import org.jreleaser.maven.plugin.FileSet;
import org.jreleaser.maven.plugin.Platform;

abstract class AbstractAssembler
implements Assembler {
    protected final Set<Artifact> output = new LinkedHashSet<Artifact>();
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    protected final List<FileSet> fileSets = new ArrayList<FileSet>();
    private final Platform platform = new Platform();
    protected String name;
    protected boolean enabled;
    protected Active active;
    protected Boolean exported;

    AbstractAssembler() {
    }

    void setAll(AbstractAssembler assembler) {
        this.active = assembler.active;
        this.enabled = assembler.enabled;
        this.exported = assembler.exported;
        this.name = assembler.name;
        this.setOutputs(assembler.output);
        this.setExtraProperties(assembler.extraProperties);
        this.setFileSets(assembler.fileSets);
        this.setPlatform(assembler.platform);
    }

    @Override
    public boolean isExported() {
        return this.exported == null || this.exported != false;
    }

    @Override
    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public String resolveActive() {
        return this.active != null ? this.active.name() : null;
    }

    @Override
    public Set<Artifact> getOutputs() {
        return this.output;
    }

    @Override
    public void setOutputs(Set<Artifact> output) {
        this.output.clear();
        this.output.addAll(output);
    }

    @Override
    public void addOutput(Artifact artifact) {
        if (null != artifact) {
            this.output.add(artifact);
        }
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public List<FileSet> getFileSets() {
        return this.fileSets;
    }

    @Override
    public void setFileSets(List<FileSet> fileSets) {
        this.fileSets.clear();
        this.fileSets.addAll(fileSets);
    }

    public void addFiles(List<FileSet> files) {
        this.fileSets.addAll(files);
    }

    public void addFile(FileSet file) {
        if (null != file) {
            this.fileSets.add(file);
        }
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public void setPlatform(Platform platform) {
        this.platform.setAll(platform);
    }
}

