/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.maven.plugin.Active;
import org.jreleaser.maven.plugin.DockerConfiguration;
import org.jreleaser.maven.plugin.Registry;
import org.jreleaser.util.StringUtils;

public abstract class AbstractDockerConfiguration
implements DockerConfiguration {
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    protected final Map<String, String> labels = new LinkedHashMap<String, String>();
    protected final Set<String> imageNames = new LinkedHashSet<String>();
    protected final List<String> buildArgs = new ArrayList<String>();
    protected final List<String> preCommands = new ArrayList<String>();
    protected final List<String> postCommands = new ArrayList<String>();
    protected final Set<Registry> registries = new LinkedHashSet<Registry>();
    protected boolean enabled;
    protected Active active;
    protected String templateDirectory;
    protected Boolean useLocalArtifact;
    protected String baseImage;

    void setAll(AbstractDockerConfiguration docker) {
        this.active = docker.active;
        this.enabled = docker.enabled;
        this.templateDirectory = docker.templateDirectory;
        this.setExtraProperties(docker.extraProperties);
        this.baseImage = docker.baseImage;
        this.useLocalArtifact = docker.useLocalArtifact;
        this.setImageNames(docker.imageNames);
        this.setBuildArgs(docker.buildArgs);
        this.setPreCommands(docker.preCommands);
        this.setPostCommands(docker.postCommands);
        this.setLabels(docker.labels);
        this.setRegistries(docker.registries);
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public void setLabels(Map<String, String> labels) {
        this.labels.clear();
        this.labels.putAll(labels);
    }

    @Override
    public Set<String> getImageNames() {
        return this.imageNames;
    }

    @Override
    public void setImageNames(Set<String> imageNames) {
        if (imageNames != null) {
            this.imageNames.clear();
            this.imageNames.addAll(imageNames);
        }
    }

    @Override
    public List<String> getBuildArgs() {
        return this.buildArgs;
    }

    @Override
    public void setBuildArgs(List<String> buildArgs) {
        if (buildArgs != null) {
            this.buildArgs.clear();
            this.buildArgs.addAll(buildArgs);
        }
    }

    @Override
    public List<String> getPreCommands() {
        return this.preCommands;
    }

    @Override
    public void setPreCommands(List<String> preCommands) {
        if (preCommands != null) {
            this.preCommands.clear();
            this.preCommands.addAll(preCommands);
        }
    }

    @Override
    public List<String> getPostCommands() {
        return this.postCommands;
    }

    @Override
    public void setPostCommands(List<String> postCommands) {
        if (postCommands != null) {
            this.postCommands.clear();
            this.postCommands.addAll(postCommands);
        }
    }

    @Override
    public Set<Registry> getRegistries() {
        return this.registries;
    }

    @Override
    public void setRegistries(Set<Registry> registries) {
        if (registries != null) {
            this.registries.clear();
            this.registries.addAll(registries);
        }
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public String resolveActive() {
        return this.active != null ? this.active.name() : null;
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void setUseLocalArtifact(Boolean useLocalArtifact) {
        this.useLocalArtifact = useLocalArtifact;
    }

    @Override
    public boolean isUseLocalArtifact() {
        return this.useLocalArtifact == null || this.useLocalArtifact != false;
    }

    @Override
    public boolean isUseLocalArtifactSet() {
        return this.useLocalArtifact != null;
    }

    public boolean isSet() {
        return null != this.active || null != this.templateDirectory || null != this.useLocalArtifact || !this.extraProperties.isEmpty() || StringUtils.isNotBlank((String)this.baseImage) || !this.imageNames.isEmpty() || !this.buildArgs.isEmpty() || !this.labels.isEmpty() || !this.registries.isEmpty();
    }
}

