/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jreleaser.engine.context.ContextCreator;
import org.jreleaser.maven.plugin.Jreleaser;
import org.jreleaser.maven.plugin.internal.JReleaserLoggerAdapter;
import org.jreleaser.maven.plugin.internal.JReleaserModelConfigurer;
import org.jreleaser.maven.plugin.internal.JReleaserModelConverter;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

abstract class AbstractJReleaserMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter
    protected Jreleaser jreleaser;
    @Parameter(property="jreleaser.output.directory", defaultValue="${project.build.directory}/jreleaser")
    protected File outputDirectory;
    @Parameter(property="jreleaser.config.file")
    protected File configFile;
    @Parameter(property="jreleaser.dry.run")
    protected boolean dryrun;
    @Parameter(property="jreleaser.git.root.search")
    protected boolean gitRootSearch;
    @Parameter(defaultValue="${session}", required=true)
    private MavenSession session;
    @Parameter(defaultValue="${maven.multiModuleProjectDirectory}")
    private String multiModuleProjectDirectory;

    AbstractJReleaserMojo() {
    }

    protected JReleaserLogger getLogger() throws MojoExecutionException {
        return new JReleaserLoggerAdapter(this.createTracer(), this.getLog());
    }

    protected PrintWriter createTracer() throws MojoExecutionException {
        try {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
            return new PrintWriter(new FileOutputStream(this.outputDirectory.toPath().resolve("trace.log").toFile()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not initialize trace file", (Exception)e);
        }
    }

    protected JReleaserModel convertModel() {
        JReleaserModel jreleaserModel = JReleaserModelConverter.convert(this.jreleaser != null ? this.jreleaser : new Jreleaser());
        return JReleaserModelConfigurer.configure(jreleaserModel, this.project, this.session);
    }

    protected JReleaserModel readModel(JReleaserLogger logger) {
        JReleaserModel jreleaserModel = ContextCreator.resolveModel((JReleaserLogger)logger, (Path)this.configFile.toPath());
        return JReleaserModelConfigurer.configure(jreleaserModel, this.project, this.session);
    }

    protected JReleaserContext createContext() throws MojoExecutionException {
        try {
            JReleaserLogger logger = this.getLogger();
            Path basedir = this.resolveBasedir();
            logger.info("JReleaser {}", new Object[]{JReleaserVersion.getPlainVersion()});
            JReleaserVersion.banner((PrintWriter)logger.getTracer());
            if (null != this.configFile) {
                logger.info("Configuring with {}", new Object[]{this.configFile.getAbsolutePath()});
            }
            logger.increaseIndent();
            logger.info("- basedir set to {}", new Object[]{basedir.toAbsolutePath()});
            logger.decreaseIndent();
            return ContextCreator.create((JReleaserLogger)logger, (JReleaserContext.Configurer)this.resolveConfigurer(this.configFile), (JReleaserContext.Mode)this.getMode(), (JReleaserModel)(null == this.configFile ? this.convertModel() : this.readModel(logger)), (Path)basedir, (Path)this.outputDirectory.toPath(), (boolean)this.dryrun, (boolean)this.gitRootSearch, this.collectSelectedPlatforms());
        }
        catch (JReleaserException e) {
            throw new MojoExecutionException("JReleaser for project " + this.project.getArtifactId() + " has not been properly configured.", (Exception)((Object)e));
        }
    }

    protected JReleaserContext.Configurer resolveConfigurer(File configFile) {
        if (null == configFile) {
            return JReleaserContext.Configurer.MAVEN;
        }
        switch (StringUtils.getFilenameExtension((String)configFile.getName())) {
            case "yml": 
            case "yaml": {
                return JReleaserContext.Configurer.CLI_YAML;
            }
            case "toml": {
                return JReleaserContext.Configurer.CLI_TOML;
            }
            case "json": {
                return JReleaserContext.Configurer.CLI_JSON;
            }
        }
        throw new IllegalArgumentException("Invalid configuration format: " + configFile.getName());
    }

    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.FULL;
    }

    private Path resolveBasedir() {
        if (StringUtils.isNotBlank((String)this.multiModuleProjectDirectory)) {
            return Paths.get(this.multiModuleProjectDirectory.trim(), new String[0]);
        }
        if (StringUtils.isNotBlank((String)this.session.getExecutionRootDirectory())) {
            return Paths.get(this.session.getExecutionRootDirectory().trim(), new String[0]);
        }
        return this.project.getBasedir().toPath();
    }

    protected List<String> collectSelectedPlatforms() {
        return Collections.emptyList();
    }

    protected List<String> collectEntries(String[] input) {
        return this.collectEntries(input, false);
    }

    protected List<String> collectEntries(String[] input, boolean lowerCase) {
        ArrayList<String> list = new ArrayList<String>();
        if (input != null && input.length > 0) {
            for (String s : input) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                s = s.trim();
                list.add(lowerCase ? s.toLowerCase() : s);
            }
        }
        return list;
    }
}

