/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jreleaser.maven.plugin.AbstractUploader;
import org.jreleaser.maven.plugin.Activatable;
import org.jreleaser.maven.plugin.Active;
import org.jreleaser.maven.plugin.FileType;
import org.jreleaser.maven.plugin.HttpUploader;
import org.jreleaser.util.StringUtils;

public class Artifactory
extends AbstractUploader {
    public static final String NAME = "artifactory";
    private final List<ArtifactoryRepository> repositories = new ArrayList<ArtifactoryRepository>();
    private String host;
    private String username;
    private String password;
    private HttpUploader.Authorization authorization;

    public Artifactory() {
        super(NAME);
    }

    public HttpUploader.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = HttpUploader.Authorization.NONE;
        }
        return this.authorization;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public HttpUploader.Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(HttpUploader.Authorization authorization) {
        this.authorization = authorization;
    }

    public List<ArtifactoryRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<ArtifactoryRepository> repositories) {
        this.repositories.clear();
        this.repositories.addAll(repositories);
    }

    public static class ArtifactoryRepository
    implements Activatable {
        private final Set<FileType> fileTypes = new LinkedHashSet<FileType>();
        private Active active;
        private String path;

        void setAll(ArtifactoryRepository repository) {
            this.active = repository.active;
            this.path = repository.path;
            this.setFileTypes(repository.fileTypes);
        }

        @Override
        public Active getActive() {
            return this.active;
        }

        @Override
        public void setActive(Active active) {
            this.active = active;
        }

        @Override
        public String resolveActive() {
            return this.active != null ? this.active.name() : null;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Set<FileType> getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(Set<FileType> fileTypes) {
            this.fileTypes.clear();
            this.fileTypes.addAll(fileTypes);
        }

        public boolean isSet() {
            return this.active != null || StringUtils.isNotBlank((String)this.path) || !this.fileTypes.isEmpty();
        }
    }
}

