/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jreleaser.engine.context.ModelAutoConfigurer;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.maven.plugin.UpdateSection;
import org.jreleaser.maven.plugin.internal.JReleaserLoggerAdapter;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.workflow.Workflows;

@Mojo(name="auto-config-release")
public class JReleaserAutoConfigReleaseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true)
    private MavenSession session;
    @Parameter(property="jreleaser.output.directory", defaultValue="${project.build.directory}/jreleaser")
    private File outputDirectory;
    @Parameter(property="jreleaser.dry.run")
    private boolean dryrun;
    @Parameter(property="jreleaser.git.root.search")
    private boolean gitRootSearch;
    @Parameter(property="jreleaser.project.name", defaultValue="${project.artifactId}")
    private String projectName;
    @Parameter(property="jreleaser.project.version", defaultValue="${project.version}")
    private String projectVersion;
    @Parameter(property="jreleaser.project.version.pattern")
    private String projectVersionPattern;
    @Parameter(property="jreleaser.project.snapshot.pattern")
    private String projectSnapshotPattern;
    @Parameter(property="jreleaser.project.snapshot.label")
    private String projectSnapshotLabel;
    @Parameter(property="jreleaser.project.snapshot.full.changelog")
    boolean projectSnapshotFullChangelog;
    @Parameter(property="jreleaser.tag.name")
    private String tagName;
    @Parameter(property="jreleaser.previous.tag.name")
    private String previousTagName;
    @Parameter(property="jreleaser.release.name")
    private String releaseName;
    @Parameter(property="jreleaser.release.branch")
    private String branch;
    @Parameter(property="jreleaser.milestone.name")
    private String milestoneName;
    @Parameter(property="jreleaser.prerelease")
    private boolean prerelease;
    @Parameter(property="jreleaser.prerelease.pattern")
    private String prereleasePattern;
    @Parameter(property="jreleaser.draft")
    private boolean draft;
    @Parameter(property="jreleaser.overwrite")
    private boolean overwrite;
    @Parameter(property="jreleaser.update")
    private boolean update;
    @Parameter(property="jreleaser.update.sections")
    private UpdateSection[] updateSections;
    @Parameter(property="jreleaser.skip.tag")
    private boolean skipTag;
    @Parameter(property="jreleaser.skip.release")
    private boolean skipRelease;
    @Parameter(property="jreleaser.changelog")
    private String changelog;
    @Parameter(property="jreleaser.changelog.formatted")
    private boolean changelogFormatted;
    @Parameter(property="jreleaser.username")
    private String username;
    @Parameter(property="jreleaser.commit.author.name")
    private String commitAuthorName;
    @Parameter(property="jreleaser.commit.author.email")
    private String commitAuthorEmail;
    @Parameter(property="jreleaser.signing")
    private boolean signing;
    @Parameter(property="jreleaser.armored")
    private boolean armored;
    @Parameter(property="jreleaser.files")
    private String[] files;
    @Parameter(property="jreleaser.globs")
    private String[] globs;
    @Parameter(property="jreleaser.select.current.platform")
    private boolean selectCurrentPlatform;
    @Parameter(property="jreleaser.select.platform")
    private String[] selectPlatforms;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        JReleaserContext context = ModelAutoConfigurer.builder().logger(this.getLogger()).basedir(this.project.getBasedir().toPath()).outputDirectory(this.outputDirectory.toPath()).dryrun(this.dryrun).gitRootSearch(this.gitRootSearch).projectName(this.projectName).projectVersion(this.projectVersion).projectVersionPattern(this.projectVersionPattern).projectSnapshotPattern(this.projectSnapshotPattern).projectSnapshotLabel(this.projectSnapshotLabel).projectSnapshotFullChangelog(this.projectSnapshotFullChangelog).tagName(this.tagName).previousTagName(this.previousTagName).releaseName(this.releaseName).branch(this.branch).milestoneName(this.milestoneName).prerelease(this.prerelease).prereleasePattern(this.prereleasePattern).draft(this.draft).overwrite(this.overwrite).update(this.update).updateSections(this.collectUpdateSections()).skipTag(this.skipTag).skipRelease(this.skipRelease).changelog(this.changelog).changelogFormatted(this.changelogFormatted).username(this.username).commitAuthorName(this.commitAuthorName).commitAuthorEmail(this.commitAuthorEmail).signing(this.signing).armored(this.armored).files(this.collectFiles()).globs(this.collectGlobs()).selectedPlatforms(this.collectSelectedPlatforms()).autoConfigure();
        Workflows.release((JReleaserContext)context).execute();
    }

    private JReleaserLogger getLogger() throws MojoExecutionException {
        return new JReleaserLoggerAdapter(this.createTracer(), this.getLog());
    }

    private PrintWriter createTracer() throws MojoExecutionException {
        try {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
            return new PrintWriter(new FileOutputStream(this.outputDirectory.toPath().resolve("trace.log").toFile()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not initialize trace file", (Exception)e);
        }
    }

    private List<String> collectFiles() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.files != null && this.files.length > 0) {
            Collections.addAll(list, this.files);
        }
        return list;
    }

    private List<String> collectGlobs() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.globs != null && this.globs.length > 0) {
            Collections.addAll(list, this.globs);
        }
        return list;
    }

    private Set<org.jreleaser.model.UpdateSection> collectUpdateSections() {
        LinkedHashSet<org.jreleaser.model.UpdateSection> set = new LinkedHashSet<org.jreleaser.model.UpdateSection>();
        if (this.updateSections != null && this.updateSections.length > 0) {
            for (UpdateSection updateSection : this.updateSections) {
                set.add(org.jreleaser.model.UpdateSection.of((String)updateSection.name()));
            }
        }
        return set;
    }

    protected List<String> collectSelectedPlatforms() {
        if (this.selectCurrentPlatform) {
            return Collections.singletonList(PlatformUtils.getCurrentFull());
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.selectPlatforms != null && this.selectPlatforms.length > 0) {
            Collections.addAll(list, this.selectPlatforms);
        }
        return list;
    }
}

