/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2020-2023 The JReleaser authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jreleaser.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.jreleaser.model.internal.JReleaserContext;

/**
 * @author Andres Almiray
 * @since 1.5.0
 */
abstract class AbstractPackagerMojo extends AbstractDistributionMojo {
    /**
     * Include a packager.
     */
    @Parameter(property = "jreleaser.packagers")
    private String[] includedPackagers;

    /**
     * Exclude a packager.
     */
    @Parameter(property = "jreleaser.excluded.packagers")
    private String[] excludedPackagers;

    @Override
    protected JReleaserContext setupContext() throws MojoExecutionException {
        JReleaserContext context = super.setupContext();
        context.setIncludedPackagers(collectEntries(includedPackagers, true));
        context.setExcludedPackagers(collectEntries(excludedPackagers, true));
        return context;
    }
}
