/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jreleaser.util.IoUtils;

final class Banner {
    private static final Banner INSTANCE = new Banner();
    private final ResourceBundle bundle = ResourceBundle.getBundle(Banner.class.getName());
    private final String productVersion = this.bundle.getString("product.version");
    private final String productId = this.bundle.getString("product.id");
    private final String productName = this.bundle.getString("product.name");
    private final String message = MessageFormat.format(this.bundle.getString("product.banner"), this.productName, this.productVersion);
    private final List<String> visited = new ArrayList<String>();

    private Banner() {
    }

    public static void display(MavenProject project, Log log) {
        block9: {
            if (Banner.INSTANCE.visited.contains(project.getName())) {
                return;
            }
            Banner.INSTANCE.visited.add(project.getName());
            boolean quiet = log.isErrorEnabled() && !log.isWarnEnabled() && !log.isInfoEnabled() && !log.isDebugEnabled();
            try {
                File parent = new File(System.getProperty("user.home"), "/.m2/caches");
                File markerFile = Banner.getMarkerFile(parent);
                if (!markerFile.exists()) {
                    if (!quiet) {
                        log.info((CharSequence)Banner.INSTANCE.message);
                    }
                    markerFile.getParentFile().mkdirs();
                    PrintStream out = IoUtils.newPrintStream((OutputStream)Files.newOutputStream(markerFile.toPath(), new OpenOption[0]));
                    out.println("1");
                    out.close();
                    Banner.writeQuietly(markerFile, "1");
                    break block9;
                }
                try {
                    int count = Integer.parseInt(Banner.readQuietly(markerFile));
                    if (count < 3 && !quiet) {
                        log.info((CharSequence)Banner.INSTANCE.message);
                    }
                    Banner.writeQuietly(markerFile, count + 1 + "");
                }
                catch (NumberFormatException e) {
                    Banner.writeQuietly(markerFile, "1");
                    if (!quiet) {
                        log.info((CharSequence)Banner.INSTANCE.message);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void writeQuietly(File file, String text) {
        try {
            PrintStream out = IoUtils.newPrintStream((OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            out.println(text);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String readQuietly(File file) {
        Scanner in = IoUtils.newScanner((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
        try {
            String string = in.next();
            if (in != null) {
                in.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception ignored) {
                return "";
            }
        }
    }

    private static File getMarkerFile(File parent) {
        return new File(parent, "jreleaser" + File.separator + Banner.INSTANCE.productId + File.separator + Banner.INSTANCE.productVersion + File.separator + "marker.txt");
    }
}

