/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jreleaser.maven.plugin.AbstractJReleaserMojo;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;

@Mojo(threadSafe=true, name="download")
public class JReleaserDownloadMojo
extends AbstractJReleaserMojo {
    @Parameter(property="jreleaser.downloaders")
    private String[] includedDownloaders;
    @Parameter(property="jreleaser.excluded.downloaders")
    private String[] excludedDownloaders;
    @Parameter(property="jreleaser.downloader.names")
    private String[] includedDownloaderNames;
    @Parameter(property="jreleaser.excluded.downloader.names")
    private String[] excludedDownloaderNames;
    @Parameter(property="jreleaser.download.skip")
    private boolean skip;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        JReleaserContext context = this.createContext();
        context.setIncludedDownloaderTypes(this.collectEntries(this.includedDownloaders, true));
        context.setIncludedDownloaderNames(this.collectEntries(this.includedDownloaderNames));
        context.setExcludedDownloaderTypes(this.collectEntries(this.excludedDownloaders, true));
        context.setExcludedDownloaderNames(this.collectEntries(this.excludedDownloaderNames));
        Workflows.download((JReleaserContext)context).execute();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.DOWNLOAD;
    }

    @Override
    protected boolean isSkip() {
        return this.skip;
    }
}

