/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jreleaser.engine.environment.Environment;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.maven.plugin.internal.JReleaserLoggerAdapter;
import org.jreleaser.util.IoUtils;

@Mojo(threadSafe=true, name="env")
public class JReleaserEnvMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="jreleaser.env.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution has been explicitly skipped.");
            return;
        }
        Environment.display((JReleaserLogger)this.getLogger(), (Path)this.project.getBasedir().toPath());
    }

    protected JReleaserLogger getLogger() {
        return new JReleaserLoggerAdapter(this.createTracer(), this.getLog());
    }

    protected PrintWriter createTracer() {
        return IoUtils.newPrintWriter((OutputStream)new ByteArrayOutputStream());
    }
}

