/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jreleaser.engine.context.ModelValidator;
import org.jreleaser.maven.plugin.AbstractPlatformAwareMojo;
import org.jreleaser.maven.plugin.internal.MavenJReleaserModelPrinter;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.util.IoUtils;

@Mojo(threadSafe=true, name="config")
public class JReleaserConfigMojo
extends AbstractPlatformAwareMojo {
    @Parameter(property="jreleaser.config.skip")
    private boolean skip;
    @Parameter(property="jreleaser.config.full")
    private boolean full;
    @Parameter(property="jreleaser.config.announce")
    private boolean announce;
    @Parameter(property="jreleaser.config.assembly")
    private boolean assembly;
    @Parameter(property="jreleaser.config.changelog")
    private boolean changelog;
    @Parameter(property="jreleaser.config.download")
    private boolean download;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        JReleaserContext context = this.createContext();
        ModelValidator.validate((JReleaserContext)context);
        new MavenJReleaserModelPrinter(IoUtils.newPrintWriter((OutputStream)System.out)).print(context.getModel().asMap(this.full));
        context.report();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        if (this.download) {
            return JReleaserContext.Mode.DOWNLOAD;
        }
        if (this.assembly) {
            return JReleaserContext.Mode.ASSEMBLE;
        }
        if (this.changelog) {
            return JReleaserContext.Mode.CHANGELOG;
        }
        if (this.announce) {
            return JReleaserContext.Mode.ANNOUNCE;
        }
        return JReleaserContext.Mode.CONFIG;
    }

    @Override
    protected boolean isSkip() {
        return this.skip;
    }
}

