/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jreleaser.engine.context.ModelValidator;
import org.jreleaser.engine.templates.TemplateEvaluator;
import org.jreleaser.maven.plugin.AbstractPlatformAwareMojo;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;

@Mojo(threadSafe=true, name="template-eval")
public class JReleaserTemplateEvalMojo
extends AbstractPlatformAwareMojo {
    @Parameter(property="jreleaser.template.skip")
    private boolean skip;
    @Parameter(property="jreleaser.config.full")
    private boolean full;
    @Parameter(property="jreleaser.config.announce")
    private boolean announce;
    @Parameter(property="jreleaser.config.assembly")
    private boolean assembly;
    @Parameter(property="jreleaser.config.changelog")
    private boolean changelog;
    @Parameter(property="jreleaser.config.download")
    private boolean download;
    @Parameter(property="jreleaser.template.overwrite")
    private boolean overwrite;
    @Parameter(property="jreleaser.template.input.file")
    protected File templateFile;
    @Parameter(property="jreleaser.template.input.directory")
    protected File inputDirectory;
    @Parameter(property="jreleaser.template.target.directory", required=true)
    protected File targetDirectory;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        JReleaserContext context = this.createContext();
        ModelValidator.validate((JReleaserContext)context);
        if (null != this.templateFile) {
            TemplateEvaluator.generateTemplate((JReleaserContext)context, (Path)this.templateFile.toPath(), (Path)context.relativizeToBasedir(this.targetDirectory.toPath()), (boolean)this.overwrite);
        } else if (null != this.inputDirectory) {
            TemplateEvaluator.generateTemplates((JReleaserContext)context, (Path)this.inputDirectory.toPath(), (Path)context.relativizeToBasedir(this.targetDirectory.toPath()), (boolean)this.overwrite);
        }
        context.report();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        if (this.download) {
            return JReleaserContext.Mode.DOWNLOAD;
        }
        if (this.assembly) {
            return JReleaserContext.Mode.ASSEMBLE;
        }
        if (this.changelog) {
            return JReleaserContext.Mode.CHANGELOG;
        }
        if (this.announce) {
            return JReleaserContext.Mode.ANNOUNCE;
        }
        return JReleaserContext.Mode.CONFIG;
    }

    @Override
    protected boolean isSkip() {
        return this.skip;
    }
}

