/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jreleaser.maven.plugin.AbstractPlatformAwareJReleaserMojo;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.workflow.Workflows;

@Mojo(name="assemble")
public class JReleaserAssembleMojo
extends AbstractPlatformAwareJReleaserMojo {
    @Parameter(property="jreleaser.assemblers")
    private String[] includedAssemblers;
    @Parameter(property="jreleaser.excluded.assemblers")
    private String[] excludedAssemblers;
    @Parameter(property="jreleaser.distributions")
    private String[] includedDistributions;
    @Parameter(property="jreleaser.excluded.distributions")
    private String[] excludedDistributions;
    @Parameter(property="jreleaser.assemble.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution has been explicitly skipped.");
            return;
        }
        JReleaserContext context = this.createContext();
        context.setIncludedAssemblers(this.collectEntries(this.includedAssemblers, true));
        context.setIncludedDistributions(this.collectEntries(this.includedDistributions));
        context.setExcludedAssemblers(this.collectEntries(this.excludedAssemblers, true));
        context.setExcludedDistributions(this.collectEntries(this.excludedDistributions));
        Workflows.assemble((JReleaserContext)context).execute();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.ASSEMBLE;
    }
}

