/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.PrintWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jreleaser.engine.context.ModelValidator;
import org.jreleaser.maven.plugin.AbstractPlatformAwareJReleaserMojo;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.maven.plugin.internal.JReleaserModelPrinter;
import org.jreleaser.model.JReleaserContext;

@Mojo(name="config")
public class JReleaserConfigMojo
extends AbstractPlatformAwareJReleaserMojo {
    @Parameter(property="jreleaser.config.skip")
    private boolean skip;
    @Parameter(property="jreleaser.config.full")
    private boolean full;
    @Parameter(property="jreleaser.config.assembly")
    private boolean assembly;
    @Parameter(property="jreleaser.config.download")
    private boolean download;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution has been explicitly skipped.");
            return;
        }
        JReleaserContext context = this.createContext();
        ModelValidator.validate((JReleaserContext)context);
        new JReleaserModelPrinter(new PrintWriter(System.out, true)).print(context.getModel().asMap(this.full));
        context.report();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        if (this.download) {
            return JReleaserContext.Mode.DOWNLOAD;
        }
        if (this.assembly) {
            return JReleaserContext.Mode.ASSEMBLE;
        }
        return JReleaserContext.Mode.CONFIG;
    }
}

