/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jreleaser.maven.plugin.AbstractPlatformAwareJReleaserMojo;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.workflow.Workflows;

@Mojo(name="upload")
public class JReleaserUploadMojo
extends AbstractPlatformAwareJReleaserMojo {
    @Parameter(property="jreleaser.uploaders")
    private String[] includedUploaders;
    @Parameter(property="jreleaser.excluded.uploaders")
    private String[] excludedUploaders;
    @Parameter(property="jreleaser.uploader.names")
    private String[] includedUploaderNames;
    @Parameter(property="jreleaser.excluded.uploader.names")
    private String[] excludedUploaderNames;
    @Parameter(property="jreleaser.distributions")
    private String[] includedDistributions;
    @Parameter(property="jreleaser.excluded.distributions")
    private String[] excludedDistributions;
    @Parameter(property="jreleaser.upload.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution has been explicitly skipped.");
            return;
        }
        JReleaserContext context = this.createContext();
        context.setIncludedUploaderTypes(this.collectEntries(this.includedUploaders, true));
        context.setIncludedUploaderNames(this.collectEntries(this.includedUploaderNames));
        context.setIncludedDistributions(this.collectEntries(this.includedDistributions));
        context.setExcludedUploaderTypes(this.collectEntries(this.excludedUploaders, true));
        context.setExcludedUploaderNames(this.collectEntries(this.excludedUploaderNames));
        context.setExcludedDistributions(this.collectEntries(this.excludedDistributions));
        Workflows.upload((JReleaserContext)context).execute();
    }
}

