/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.maven.plugin.internal.JReleaserLoggerAdapter;
import org.jreleaser.model.Distribution;
import org.jreleaser.templates.TemplateGenerationException;
import org.jreleaser.templates.TemplateGenerator;

@Mojo(name="template")
public class JReleaserTemplateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="jreleaser.template.skip")
    private boolean skip;
    @Parameter(property="jreleaser.template.distribution.name")
    private String distributionName;
    @Parameter(property="jreleaser.template.distribution.type", defaultValue="JAVA_BINARY")
    private final Distribution.DistributionType distributionType = Distribution.DistributionType.JAVA_BINARY;
    @Parameter(property="jreleaser.template.packager.name")
    private String packagerName;
    @Parameter(property="jreleaser.announcer.name")
    private String announcerName;
    @Parameter(property="jreleaser.template.overwrite")
    private boolean overwrite;
    @Parameter(property="jreleaser.template.snapshot")
    private boolean snapshot;
    @Parameter(property="jreleaser.output.directory", defaultValue="${project.build.directory}/jreleaser")
    protected File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution has been explicitly skipped.");
            return;
        }
        try {
            Path outputDirectory = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve("src").resolve("jreleaser");
            Path output = TemplateGenerator.builder().logger(this.getLogger()).distributionName(this.distributionName).distributionType(this.distributionType).packagerName(this.packagerName).announcerName(this.announcerName).outputDirectory(outputDirectory).overwrite(this.overwrite).snapshot(this.snapshot).build().generate();
            if (null != output) {
                this.getLogger().info("Template generated at {}", new Object[]{output.toAbsolutePath()});
            }
        }
        catch (TemplateGenerationException e) {
            throw new MojoExecutionException("Unexpected error", (Exception)((Object)e));
        }
    }

    protected JReleaserLogger getLogger() throws MojoExecutionException {
        return new JReleaserLoggerAdapter(this.createTracer(), this.getLog());
    }

    protected PrintWriter createTracer() throws MojoExecutionException {
        try {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
            return new PrintWriter(new FileOutputStream(this.outputDirectory.toPath().resolve("trace.log").toFile()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not initialize trace file", (Exception)e);
        }
    }
}

