/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jreleaser.util.IoUtils;

final class Banner {
    private static final Banner BANNER = new Banner();
    private final ResourceBundle bundle = ResourceBundle.getBundle(Banner.class.getName());
    private final String productVersion = this.bundle.getString("product.version");
    private final String productId = this.bundle.getString("product.id");
    private final String productName = this.bundle.getString("product.name");
    private final String banner = MessageFormat.format(this.bundle.getString("product.banner"), this.productName, this.productVersion);
    private final List<String> visited = new ArrayList<String>();

    private Banner() {
    }

    public static void display(MavenProject project, Log log) {
        block9: {
            if (Banner.BANNER.visited.contains(project.getName())) {
                return;
            }
            Banner.BANNER.visited.add(project.getName());
            boolean quiet = log.isErrorEnabled() && !log.isWarnEnabled() && !log.isInfoEnabled() && !log.isDebugEnabled();
            try {
                File parent = new File(System.getProperty("user.home"), "/.m2/caches");
                File markerFile = Banner.getMarkerFile(parent, BANNER);
                if (!markerFile.exists()) {
                    if (!quiet) {
                        System.out.println(Banner.BANNER.banner);
                    }
                    markerFile.getParentFile().mkdirs();
                    PrintStream out = IoUtils.newPrintStream((OutputStream)new FileOutputStream(markerFile));
                    out.println("1");
                    out.close();
                    Banner.writeQuietly(markerFile, "1");
                    break block9;
                }
                try {
                    int count = Integer.parseInt(Banner.readQuietly(markerFile));
                    if (count < 3 && !quiet) {
                        System.out.println(Banner.BANNER.banner);
                    }
                    Banner.writeQuietly(markerFile, count + 1 + "");
                }
                catch (NumberFormatException e) {
                    Banner.writeQuietly(markerFile, "1");
                    if (!quiet) {
                        System.out.println(Banner.BANNER.banner);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void writeQuietly(File file, String text) {
        try {
            PrintStream out = IoUtils.newPrintStream((OutputStream)new FileOutputStream(file));
            out.println(text);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String readQuietly(File file) {
        try {
            Scanner in = IoUtils.newScanner((InputStream)new FileInputStream(file));
            return in.next();
        }
        catch (Exception ignored) {
            return "";
        }
    }

    private static File getMarkerFile(File parent, Banner b) {
        return new File(parent, "jreleaser" + File.separator + b.productId + File.separator + b.productVersion + File.separator + "marker.txt");
    }
}

