/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jreleaser.engine.init.Init;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.maven.plugin.Banner;
import org.jreleaser.maven.plugin.internal.JReleaserLoggerAdapter;
import org.jreleaser.util.IoUtils;

@Mojo(name="init")
public class JReleaserInitMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="jreleaser.output.directory", defaultValue="${project.basedir}")
    protected File outputDirectory;
    @Parameter(property="jreleaser.init.skip")
    private boolean skip;
    @Parameter(property="jreleaser.init.format")
    private String format;
    @Parameter(property="jreleaser.template.overwrite")
    private boolean overwrite;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Banner.display(this.project, this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution has been explicitly skipped.");
            return;
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.project.getBasedir();
        }
        try (JReleaserLogger logger = this.getLogger();){
            Init.execute((JReleaserLogger)logger, (String)this.format, (boolean)this.overwrite, (Path)this.outputDirectory.toPath());
        }
    }

    protected JReleaserLogger getLogger() throws MojoExecutionException {
        return new JReleaserLoggerAdapter(this.createTracer(), this.getLog());
    }

    protected PrintWriter createTracer() throws MojoExecutionException {
        try {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
            return IoUtils.newPrintWriter((OutputStream)new FileOutputStream(this.outputDirectory.toPath().resolve("trace.log").toFile()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not initialize trace file", (Exception)e);
        }
    }
}

