/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.common.AbstractArtifact;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.validation.assemble.AssemblersValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class JlinkAssemblerValidator {
    private JlinkAssemblerValidator() {
    }

    public static void validateJlink(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, JlinkAssembler> jlink = context.getModel().getAssemble().getJlink();
        if (!jlink.isEmpty()) {
            context.getLogger().debug("assemble.jlink");
        }
        for (Map.Entry<String, JlinkAssembler> e : jlink.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            JlinkAssemblerValidator.validateJlink(context, mode, e.getValue(), errors);
        }
    }

    private static void validateJlink(JReleaserContext context, JReleaserContext.Mode mode, JlinkAssembler assembler, Errors errors) {
        boolean hasJavaArchive;
        context.getLogger().debug("assemble.jlink.{}", new Object[]{assembler.getName()});
        Validator.resolveActivatable(context, (Activatable)assembler, CollectionUtils.listOf((Object[])new String[]{"assemble.jlink." + assembler.getName(), "assemble.jlink"}), "NEVER");
        if (!assembler.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)assembler.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"jlink.name"}));
            return;
        }
        context.getLogger().debug("assemble.jlink.{}.java", new Object[]{assembler.getName()});
        if (!AssemblersValidator.validateJava(context, assembler, errors)) {
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            assembler.disable();
            return;
        }
        if (StringUtils.isBlank((String)assembler.getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"assembler." + assembler.getName() + ".java.groupId"}));
        }
        assembler.setPlatform(assembler.getPlatform().mergeValues(context.getModel().getPlatform()));
        if (StringUtils.isBlank((String)assembler.getImageName())) {
            assembler.setImageName(assembler.getJava().getGroupId() + "." + assembler.getJava().getArtifactId() + "-" + context.getModel().getProject().getResolvedVersion());
        }
        if (StringUtils.isBlank((String)assembler.getExecutable())) {
            assembler.setExecutable(assembler.getName());
        }
        int i = 0;
        for (Artifact targetJdk : assembler.getTargetJdks()) {
            JlinkAssemblerValidator.validateJdk(context, mode, assembler, targetJdk, i++, errors);
        }
        Map<String, List<Artifact>> byPlatform = assembler.getTargetJdks().stream().filter(AbstractArtifact::isActiveAndSelected).collect(Collectors.groupingBy(jdk -> StringUtils.isBlank((String)jdk.getPlatform()) ? "<nil>" : jdk.getPlatform()));
        if (byPlatform.containsKey("<nil>")) {
            errors.configuration(RB.$((String)"validation_jlink_jdk_platform", (Object[])new Object[]{assembler.getName()}));
        }
        byPlatform.forEach((p, jdks) -> {
            if (jdks.size() > 1) {
                errors.configuration(RB.$((String)"validation_jlink_jdk_multiple_platforms", (Object[])new Object[]{assembler.getName(), p}));
            }
        });
        if (StringUtils.isBlank((String)assembler.getJdk().getPath())) {
            String currentPlatform = PlatformUtils.getCurrentFull();
            String javaHome = System.getProperty("java.home");
            if (assembler.getTargetJdks().isEmpty()) {
                if (StringUtils.isBlank((String)javaHome)) {
                    errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                    return;
                }
                assembler.getJdk().resolveEnabled(context.getModel().getProject());
                assembler.getJdk().setPath(javaHome);
                assembler.getJdk().setPlatform(currentPlatform);
                assembler.addTargetJdk(assembler.getJdk());
            } else {
                Optional<Artifact> jdk2 = assembler.getTargetJdks().stream().filter(AbstractArtifact::isActiveAndSelected).filter(j -> PlatformUtils.isCompatible((String)currentPlatform, (String)j.getPlatform())).findFirst();
                if (jdk2.isPresent()) {
                    assembler.setJdk(jdk2.get());
                } else {
                    if (StringUtils.isBlank((String)javaHome)) {
                        errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                        return;
                    }
                    assembler.getJdk().setPath(javaHome);
                    assembler.getJdk().setPlatform(currentPlatform);
                }
            }
            assembler.getJdk().select();
        }
        if (assembler.getArgs().isEmpty()) {
            assembler.getArgs().add("--no-header-files");
            assembler.getArgs().add("--no-man-pages");
            assembler.getArgs().add("--compress=2");
            assembler.getArgs().add("--strip-debug");
        }
        if (hasJavaArchive = assembler.getJavaArchive().isSet()) {
            if (StringUtils.isBlank((String)assembler.getJavaArchive().getMainJarName())) {
                assembler.getJavaArchive().setMainJarName("{{projectName}}-{{projectVersion}}.jar");
            }
            if (StringUtils.isBlank((String)assembler.getJavaArchive().getLibDirectoryName())) {
                assembler.getJavaArchive().setLibDirectoryName("lib");
            }
        }
        if (!AssemblersValidator.validateJavaAssembler(context, mode, assembler, errors, !hasJavaArchive)) {
            return;
        }
        if (!hasJavaArchive) {
            assembler.getMainJar().resolveActiveAndSelected(context);
        }
        if (null == assembler.getArchiveFormat()) {
            assembler.setArchiveFormat(Archive.Format.ZIP);
        }
        if (null == assembler.getOptions().getTimestamp()) {
            assembler.getOptions().setTimestamp(context.getModel().resolveArchiveTimestamp());
        }
        if (!assembler.getJdeps().isEnabledSet()) {
            assembler.getJdeps().setEnabled(true);
        }
        if (!assembler.getJdeps().isEnabled() && assembler.getModuleNames().isEmpty()) {
            assembler.getModuleNames().add("java.base");
        }
        if (!assembler.getModuleNames().isEmpty()) {
            assembler.getJdeps().setEnabled(false);
        }
    }

    private static void validateJdk(JReleaserContext context, JReleaserContext.Mode mode, JlinkAssembler jlink, Artifact jdk, int index, Errors errors) {
        if (mode == JReleaserContext.Mode.FULL) {
            return;
        }
        if (null == jdk) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"jlink." + jlink.getName() + ".targetJdk[" + index + "]"}));
            return;
        }
        if (!jdk.resolveActiveAndSelected(context)) {
            return;
        }
        if (StringUtils.isBlank((String)jdk.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"jlink." + jlink.getName() + ".targetJdk[" + index + "].path"}));
        }
        if (StringUtils.isBlank((String)jdk.getPlatform())) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"jlink." + jlink.getName() + ".targetJdk[" + index + "].platform"}));
        }
        if (StringUtils.isNotBlank((String)jdk.getPlatform()) && !PlatformUtils.isSupported((String)jdk.getPlatform().trim())) {
            context.getLogger().warn(RB.$((String)"validation_jlink_platform", (Object[])new Object[]{jlink.getName(), index, jdk.getPlatform(), System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()}));
        }
    }
}

