/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class JlinkAssemblerResolver {
    private JlinkAssemblerResolver() {
    }

    public static void resolveJlinkOutputs(JReleaserContext context, Errors errors) {
        List<JlinkAssembler> activeJlinks = context.getModel().getAssemble().getActiveJlinks();
        if (!activeJlinks.isEmpty()) {
            context.getLogger().debug("assemble.jlink");
        }
        for (JlinkAssembler jlink : activeJlinks) {
            if (!jlink.isExported()) continue;
            JlinkAssemblerResolver.resolveJlinkOutputs(context, jlink, errors);
        }
    }

    public static void resolveJlinkOutputs(JReleaserContext context, JlinkAssembler assembler, Errors errors) {
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(assembler.getName()).resolve(assembler.getType());
        String imageName = assembler.getResolvedImageName(context);
        if (StringUtils.isNotBlank((String)assembler.getImageNameTransform())) {
            imageName = assembler.getResolvedImageNameTransform(context);
        }
        for (Artifact targetJdk : assembler.getTargetJdks()) {
            if (!targetJdk.isActiveAndSelected()) continue;
            String platform = targetJdk.getPlatform();
            String platformReplaced = assembler.getPlatform().applyReplacements(platform);
            String str = targetJdk.getExtraProperties().getOrDefault("archiveFormat", assembler.getArchiveFormat()).toString();
            Archive.Format archiveFormat = Archive.Format.of((String)str);
            Path image = baseOutputDirectory.resolve(imageName + "-" + platformReplaced + "." + archiveFormat.extension()).toAbsolutePath();
            if (!Files.exists(image, new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{assembler.getType(), assembler.getName(), assembler.getName()}));
                continue;
            }
            Artifact artifact = Artifact.of(image, platform);
            artifact.resolveActiveAndSelected(context);
            artifact.setExtraProperties(assembler.getExtraProperties());
            assembler.addOutput(artifact);
        }
    }
}

