/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.catalog.swid;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.swid.Entity;
import org.jreleaser.model.internal.catalog.swid.SwidTag;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Java;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SwidTagValidator {
    private SwidTagValidator() {
    }

    public static void validateSwid(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, SwidTag> swid = context.getModel().getCatalog().getSwid();
        if (swid.isEmpty()) {
            swid.put("swid-tag", new SwidTag());
        }
        context.getLogger().debug("catalog.swid");
        for (Map.Entry<String, SwidTag> e : swid.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            SwidTagValidator.validateSwid(context, e.getValue(), errors);
        }
    }

    private static void validateSwid(JReleaserContext context, SwidTag tag, Errors errors) {
        context.getLogger().debug("catalog.swid.{}", new Object[]{tag.getName()});
        Validator.resolveActivatable(context, (Activatable)tag, CollectionUtils.listOf((Object[])new String[]{"catalog.swid." + tag.getName(), "catalog.swid"}), "NEVER");
        tag.resolveEnabled(context.getModel().getProject());
        if (StringUtils.isBlank((String)tag.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"swid.name"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            tag.disable();
            return;
        }
        SwidTagValidator.validateSwidTag(context, tag, errors);
    }

    public static void validateSwid(JReleaserContext context, SwidTag tag, String activatablePath, Errors errors) {
        String tagRef = tag.getTagRef();
        SwidTag other = context.getModel().getCatalog().getSwid().get(tagRef);
        SwidTagValidator.validateSwid(context, tag, other, activatablePath, errors);
    }

    private static void validateSwid(JReleaserContext context, SwidTag tag, SwidTag other, String activatablePath, Errors errors) {
        Validator.resolveActivatable(context, (Activatable)tag, CollectionUtils.listOf((Object[])new String[]{activatablePath + ".swid." + tag.getName(), activatablePath + ".swid"}), null);
        tag.copyFrom(other);
        if (!tag.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        SwidTagValidator.validateSwidTag(context, tag, errors);
    }

    private static void validateSwidTag(JReleaserContext context, SwidTag tag, Errors errors) {
        if (StringUtils.isBlank((String)tag.getLang())) {
            tag.setLang("en-US");
        }
        if (StringUtils.isBlank((String)tag.getPath())) {
            tag.setPath("SWIDTAG");
        }
        if (null == tag.getTagVersion()) {
            tag.setTagVersion(1);
        }
        if (tag.getTagVersion() < 1) {
            errors.configuration(RB.$((String)"validation_must_be greater_than", (Object[])new Object[]{"swid.tagVersion", "0"}));
        }
        Project project = context.getModel().getProject();
        if (StringUtils.isBlank((String)tag.getTagId())) {
            Java java = project.getLanguages().getJava();
            if (java.isEnabled()) {
                tag.setTagId(UUID.nameUUIDFromBytes((java.getGroupId() + "-" + java.getArtifactId() + "-" + project.getVersion()).getBytes(StandardCharsets.UTF_8)).toString());
            } else {
                tag.setTagId(UUID.nameUUIDFromBytes((project.getVendor() + "-" + project.getName() + "_" + project.getVersion()).getBytes(StandardCharsets.UTF_8)).toString());
            }
        }
        if (tag.getEntities().isEmpty()) {
            Entity entity = new Entity();
            entity.setName(project.getVendor());
            if (StringUtils.isBlank((String)entity.getName())) {
                entity.setName(project.getName());
            }
            entity.setRegid(project.getLinks().getHomepage());
            if (StringUtils.isBlank((String)entity.getRegid())) {
                entity.setRegid("http://invalid.unavailable");
            }
            entity.setRoles(CollectionUtils.setOf((Object[])new String[]{"tagCreator", "softwareCreator"}));
            tag.getEntities().add(entity);
        }
    }
}

