/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.release;

import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.CodebergReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.release.BaseReleaserValidator;
import org.jreleaser.util.Errors;

public final class CodebergReleaserValidator {
    private CodebergReleaserValidator() {
    }

    public static boolean validateCodeberg(JReleaserContext context, JReleaserContext.Mode mode, CodebergReleaser service, Errors errors) {
        if (null == service) {
            return false;
        }
        context.getLogger().debug("release.codeberg");
        BaseReleaserValidator.validateGitService(context, mode, service, errors);
        if (context.getModel().getProject().isSnapshot()) {
            service.getPrerelease().setEnabled(true);
        }
        service.getPrerelease().setPattern(Validator.checkProperty(context, "PRERELEASE_PATTERN", "release.codeberg.prerelease.pattern", service.getPrerelease().getPattern(), ""));
        service.getPrerelease().isPrerelease(context.getModel().getProject().getResolvedVersion());
        if (!service.isDraftSet()) {
            service.setDraft(Validator.checkProperty(context, "DRAFT", "release.codeberg.draft", null, false));
        }
        if (service.isDraft()) {
            service.getMilestone().setClose(false);
        }
        return service.isEnabled();
    }
}

