/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.spi.deploy.maven;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public class Deployable
implements Comparable<Deployable> {
    public static final String PACKAGING_AAR = "aar";
    public static final String PACKAGING_JAR = "jar";
    public static final String PACKAGING_WAR = "war";
    public static final String PACKAGING_POM = "pom";
    public static final String PACKAGING_NBM = "nbm";
    public static final String PACKAGING_ZIP = "zip";
    public static final String PACKAGING_MAVEN_ARCHETYPE = "maven-archetype";
    public static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    public static final String EXT_JAR = ".jar";
    public static final String EXT_WAR = ".war";
    public static final String EXT_POM = ".pom";
    public static final String EXT_ASC = ".asc";
    public static final String EXT_MODULE = ".module";
    public static final String EXT_XML = ".xml";
    public static final String EXT_JSON = ".json";
    private static final String[] EXT_CHECKSUMS = new String[]{".md5", ".sha1", ".sha256", ".sha512"};
    private static final Set<String> JAR_EXCLUSIONS = CollectionUtils.setOf((Object[])new String[]{"pom", "aar", "war", "zip"});
    private static final Set<String> SOURCE_EXCLUSIONS = CollectionUtils.setOf((Object[])new String[]{"pom", "nbm", "aar"});
    private static final Set<String> JAVADOC_EXCLUSIONS = CollectionUtils.setOf((Object[])new String[]{"pom", "nbm", "maven-archetype", "aar"});
    private final String stagingRepository;
    private final String path;
    private final String filename;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String packaging;
    private final boolean relocated;

    public Deployable(String stagingRepository, String path, String packaging, String filename, boolean relocated) {
        this.stagingRepository = stagingRepository;
        this.path = path;
        this.filename = filename;
        this.packaging = packaging;
        this.relocated = relocated;
        if (!MAVEN_METADATA_XML.equals(filename)) {
            Path p = Paths.get(path, new String[0]);
            this.version = p.getFileName().toString();
            p = p.getParent();
            this.artifactId = p.getFileName().toString();
            String gid = (p = p.getParent()).toString().replace("/", ".").replace("\\", ".");
            if (gid.startsWith(".")) {
                gid = gid.substring(1);
            }
            this.groupId = gid;
        } else {
            this.version = "";
            this.artifactId = "";
            this.groupId = "";
        }
    }

    public TemplateContext props() {
        TemplateContext props = new TemplateContext();
        props.set("groupId", (Object)this.groupId);
        props.set("artifactId", (Object)this.artifactId);
        props.set("version", (Object)this.version);
        props.set("filename", (Object)this.filename);
        props.set("path", (Object)this.getDeployPath());
        return props;
    }

    public boolean requiresJar() {
        return StringUtils.isNotBlank((String)this.packaging) && !JAR_EXCLUSIONS.contains(this.packaging);
    }

    public boolean requiresWar() {
        return StringUtils.isNotBlank((String)this.packaging) && PACKAGING_WAR.equalsIgnoreCase(this.packaging);
    }

    public boolean requiresSourcesJar() {
        return StringUtils.isNotBlank((String)this.packaging) && !SOURCE_EXCLUSIONS.contains(this.packaging);
    }

    public boolean requiresJavadocJar() {
        return StringUtils.isNotBlank((String)this.packaging) && !JAVADOC_EXCLUSIONS.contains(this.packaging);
    }

    public String getGav() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String getStagingRepository() {
        return this.stagingRepository;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullDeployPath() {
        return this.getDeployPath() + "/" + this.getFilename();
    }

    public String getDeployPath() {
        return this.path.replace("\\", "/").substring(1);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Path getLocalPath() {
        return Paths.get(this.stagingRepository, this.path, this.filename);
    }

    public boolean isRelocated() {
        return this.relocated;
    }

    public Deployable deriveByFilename(String filename) {
        return new Deployable(this.stagingRepository, this.path, this.packaging, filename, false);
    }

    public Deployable deriveByFilename(String packaging, String filename) {
        return new Deployable(this.stagingRepository, this.path, packaging, filename, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        Deployable that = (Deployable)o;
        return this.stagingRepository.equals(that.stagingRepository) && this.path.equals(that.path) && this.filename.equals(that.filename);
    }

    public int hashCode() {
        return Objects.hash(this.stagingRepository, this.path, this.filename);
    }

    @Override
    public int compareTo(Deployable o) {
        if (null == o) {
            return -1;
        }
        return this.getFullDeployPath().compareTo(o.getFullDeployPath());
    }

    public boolean isArtifact() {
        return !this.isPom() && !this.isSignature() && !this.isChecksum() && !this.isJson() && !this.isXml() && !this.isGradleMetadata() && !this.isMavenMetadata();
    }

    public boolean isPom() {
        return this.filename.endsWith(EXT_POM);
    }

    public boolean isSignature() {
        return this.filename.endsWith(EXT_ASC);
    }

    public boolean isChecksum() {
        for (String ext : EXT_CHECKSUMS) {
            if (!this.filename.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public boolean isJson() {
        return this.filename.endsWith(EXT_JSON);
    }

    public boolean isXml() {
        return this.filename.endsWith(EXT_XML);
    }

    public boolean isGradleMetadata() {
        return this.filename.endsWith(EXT_MODULE);
    }

    public boolean isMavenMetadata() {
        return this.filename.endsWith(MAVEN_METADATA_XML);
    }
}

