/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.model.internal.common.MatrixAware;
import org.jreleaser.model.internal.hooks.CommandHook;
import org.jreleaser.model.internal.hooks.CommandHookProvider;

public final class NamedCommandHooks
extends AbstractActivatable<NamedCommandHooks>
implements Domain,
CommandHookProvider,
MatrixAware {
    private static final long serialVersionUID = -2922193324820421707L;
    private final List<CommandHook> before = new ArrayList<CommandHook>();
    private final List<CommandHook> success = new ArrayList<CommandHook>();
    private final List<CommandHook> failure = new ArrayList<CommandHook>();
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final Matrix matrix = new Matrix();
    private String name;
    private String condition;
    private Boolean applyDefaultMatrix;
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.NamedCommandHooks immutable = new org.jreleaser.model.api.hooks.NamedCommandHooks(){
        private static final long serialVersionUID = -5941160336124473447L;
        private List<? extends org.jreleaser.model.api.hooks.CommandHook> before;
        private List<? extends org.jreleaser.model.api.hooks.CommandHook> success;
        private List<? extends org.jreleaser.model.api.hooks.CommandHook> failure;

        public String getName() {
            return NamedCommandHooks.this.getName();
        }

        public String getCondition() {
            return NamedCommandHooks.this.getCondition();
        }

        public List<? extends org.jreleaser.model.api.hooks.CommandHook> getBefore() {
            if (null == this.before) {
                this.before = NamedCommandHooks.this.before.stream().map(CommandHook::asImmutable).collect(Collectors.toList());
            }
            return this.before;
        }

        public List<? extends org.jreleaser.model.api.hooks.CommandHook> getSuccess() {
            if (null == this.success) {
                this.success = NamedCommandHooks.this.success.stream().map(CommandHook::asImmutable).collect(Collectors.toList());
            }
            return this.success;
        }

        public List<? extends org.jreleaser.model.api.hooks.CommandHook> getFailure() {
            if (null == this.failure) {
                this.failure = NamedCommandHooks.this.failure.stream().map(CommandHook::asImmutable).collect(Collectors.toList());
            }
            return this.failure;
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(NamedCommandHooks.this.getEnvironment());
        }

        public boolean isApplyDefaultMatrix() {
            return NamedCommandHooks.this.isApplyDefaultMatrix();
        }

        public org.jreleaser.model.api.common.Matrix getMatrix() {
            return NamedCommandHooks.this.matrix.asImmutable();
        }

        public Active getActive() {
            return NamedCommandHooks.this.getActive();
        }

        public boolean isEnabled() {
            return NamedCommandHooks.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(NamedCommandHooks.this.asMap(full));
        }
    };

    public NamedCommandHooks() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.hooks.NamedCommandHooks asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(NamedCommandHooks source) {
        super.merge(source);
        this.name = this.merge(this.name, source.name);
        this.condition = this.merge(this.condition, source.condition);
        this.setBefore(this.merge(this.before, source.before));
        this.setSuccess(this.merge(this.success, source.success));
        this.setFailure(this.merge(this.failure, source.failure));
        this.setEnvironment(this.merge(this.environment, source.getEnvironment()));
        this.setMatrix(source.matrix);
    }

    @Override
    public boolean isSet() {
        return super.isSet() || !this.before.isEmpty() || !this.success.isEmpty() || !this.failure.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public List<CommandHook> getBefore() {
        return this.before;
    }

    public void setBefore(List<CommandHook> before) {
        this.before.clear();
        this.before.addAll(before);
    }

    @Override
    public List<CommandHook> getSuccess() {
        return this.success;
    }

    public void setSuccess(List<CommandHook> success) {
        this.success.clear();
        this.success.addAll(success);
    }

    @Override
    public List<CommandHook> getFailure() {
        return this.failure;
    }

    public void setFailure(List<CommandHook> failure) {
        this.failure.clear();
        this.failure.addAll(failure);
    }

    public void addBefore(CommandHook hook) {
        if (null != hook) {
            this.before.add(hook);
        }
    }

    public void addSuccess(CommandHook hook) {
        if (null != hook) {
            this.success.add(hook);
        }
    }

    public void addFailure(CommandHook hook) {
        if (null != hook) {
            this.failure.add(hook);
        }
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    @Override
    public boolean isApplyDefaultMatrixSet() {
        return null != this.applyDefaultMatrix;
    }

    @Override
    public boolean isApplyDefaultMatrix() {
        return null != this.applyDefaultMatrix && this.applyDefaultMatrix != false;
    }

    @Override
    public void setApplyDefaultMatrix(Boolean applyDefaultMatrix) {
        this.applyDefaultMatrix = applyDefaultMatrix;
    }

    @Override
    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.matrix.merge(matrix);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("name", this.name);
        map.put("condition", this.condition);
        map.put("environment", this.environment);
        this.matrix.asMap(map);
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (CommandHook hook : this.getBefore()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("before", m);
        m = new LinkedHashMap();
        i = 0;
        for (CommandHook hook : this.getSuccess()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("success", m);
        m = new LinkedHashMap();
        i = 0;
        for (CommandHook hook : this.getFailure()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("failure", m);
        return map;
    }
}

