/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Map;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.AzureMavenDeployer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.Errors;

public final class AzureMavenDeployerValidator {
    private AzureMavenDeployerValidator() {
    }

    public static void validateAzureMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, AzureMavenDeployer> azure = context.getModel().getDeploy().getMaven().getAzure();
        if (!azure.isEmpty()) {
            context.getLogger().debug("deploy.maven.azure");
        }
        for (Map.Entry<String, AzureMavenDeployer> e : azure.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateDeploy() && !mode.validateConfig()) continue;
            Errors incoming = new Errors();
            MavenDeployersValidator.validateMavenDeployer(context, e.getValue(), incoming);
            Validator.mergeErrors(context, errors, incoming, e.getValue());
        }
    }
}

