/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.release.Changelog;
import org.jreleaser.model.api.release.GithubReleaser;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;
import org.jreleaser.model.internal.release.BaseReleaser;

public final class GithubReleaser
extends BaseReleaser<org.jreleaser.model.api.release.GithubReleaser, GithubReleaser> {
    private final ReleaseNotes releaseNotes = new ReleaseNotes();
    private Boolean draft;
    private String discussionCategoryName;
    private final org.jreleaser.model.api.release.GithubReleaser immutable = new org.jreleaser.model.api.release.GithubReleaser(){

        public boolean isPrerelease() {
            return GithubReleaser.this.isPrerelease();
        }

        public boolean isDraft() {
            return GithubReleaser.this.isDraft();
        }

        public String getDiscussionCategoryName() {
            return GithubReleaser.this.discussionCategoryName;
        }

        public GithubReleaser.ReleaseNotes getReleaseNotes() {
            return GithubReleaser.this.releaseNotes.asImmutable();
        }

        public String getServiceName() {
            return GithubReleaser.this.getServiceName();
        }

        public boolean isReleaseSupported() {
            return GithubReleaser.this.isReleaseSupported();
        }

        public String getCanonicalRepoName() {
            return GithubReleaser.this.getCanonicalRepoName();
        }

        public String getReverseRepoHost() {
            return GithubReleaser.this.getReverseRepoHost();
        }

        public boolean isMatch() {
            return GithubReleaser.this.isMatch();
        }

        public String getHost() {
            return GithubReleaser.this.host;
        }

        public String getName() {
            return GithubReleaser.this.name;
        }

        public String getRepoUrl() {
            return GithubReleaser.this.repoUrl;
        }

        public String getRepoCloneUrl() {
            return GithubReleaser.this.repoCloneUrl;
        }

        public String getCommitUrl() {
            return GithubReleaser.this.commitUrl;
        }

        public String getSrcUrl() {
            return GithubReleaser.this.srcUrl;
        }

        public String getDownloadUrl() {
            return GithubReleaser.this.downloadUrl;
        }

        public String getReleaseNotesUrl() {
            return GithubReleaser.this.releaseNotesUrl;
        }

        public String getLatestReleaseUrl() {
            return GithubReleaser.this.latestReleaseUrl;
        }

        public String getIssueTrackerUrl() {
            return GithubReleaser.this.issueTrackerUrl;
        }

        public String getUsername() {
            return GithubReleaser.this.username;
        }

        public String getToken() {
            return GithubReleaser.this.token;
        }

        public String getTagName() {
            return GithubReleaser.this.tagName;
        }

        public String getPreviousTagName() {
            return GithubReleaser.this.previousTagName;
        }

        public String getReleaseName() {
            return GithubReleaser.this.releaseName;
        }

        public String getBranch() {
            return GithubReleaser.this.branch;
        }

        public Releaser.Prerelease getPrerelease() {
            return GithubReleaser.this.prerelease.asImmutable();
        }

        public boolean isSign() {
            return GithubReleaser.this.isSign();
        }

        public Changelog getChangelog() {
            return GithubReleaser.this.changelog.asImmutable();
        }

        public Releaser.Milestone getMilestone() {
            return GithubReleaser.this.milestone.asImmutable();
        }

        public Releaser.Issues getIssues() {
            return GithubReleaser.this.issues.asImmutable();
        }

        public boolean isSkipTag() {
            return GithubReleaser.this.isSkipTag();
        }

        public boolean isSkipRelease() {
            return GithubReleaser.this.isSkipRelease();
        }

        public boolean isOverwrite() {
            return GithubReleaser.this.isOverwrite();
        }

        public Releaser.Update getUpdate() {
            return GithubReleaser.this.update.asImmutable();
        }

        public String getApiEndpoint() {
            return GithubReleaser.this.apiEndpoint;
        }

        public boolean isArtifacts() {
            return GithubReleaser.this.isArtifacts();
        }

        public boolean isFiles() {
            return GithubReleaser.this.isFiles();
        }

        public boolean isChecksums() {
            return GithubReleaser.this.isChecksums();
        }

        public boolean isSignatures() {
            return GithubReleaser.this.isSignatures();
        }

        public Active getUploadAssets() {
            return GithubReleaser.this.uploadAssets;
        }

        public CommitAuthor getCommitAuthor() {
            return GithubReleaser.this.commitAuthor.asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GithubReleaser.this.asMap(full));
        }

        public boolean isEnabled() {
            return GithubReleaser.this.isEnabled();
        }

        public String getOwner() {
            return GithubReleaser.this.owner;
        }

        public Integer getConnectTimeout() {
            return GithubReleaser.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return GithubReleaser.this.readTimeout;
        }
    };

    public GithubReleaser() {
        super("github", true);
        this.setHost("github.com");
        this.setApiEndpoint("https://api.github.com");
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/blob/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/download/{{tagName}}/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/tag/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/issues");
    }

    @Override
    public org.jreleaser.model.api.release.GithubReleaser asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GithubReleaser source) {
        super.merge(source);
        this.draft = this.merge(this.draft, source.draft);
        this.discussionCategoryName = this.merge(this.discussionCategoryName, source.discussionCategoryName);
        this.setReleaseNotes(source.releaseNotes);
    }

    public boolean isDraft() {
        return this.draft != null && this.draft != false;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public boolean isDraftSet() {
        return this.draft != null;
    }

    public String getDiscussionCategoryName() {
        return this.discussionCategoryName;
    }

    public void setDiscussionCategoryName(String discussionCategoryName) {
        this.discussionCategoryName = discussionCategoryName;
    }

    public ReleaseNotes getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setReleaseNotes(ReleaseNotes releaseNotes) {
        this.releaseNotes.merge(releaseNotes);
    }

    @Override
    public String getReverseRepoHost() {
        return "com.github";
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("draft", this.isDraft());
        map.put("discussionCategoryName", this.discussionCategoryName);
        map.put("releaseNotes", this.releaseNotes.asMap(full));
        return map;
    }

    public static final class ReleaseNotes
    extends AbstractModelObject<ReleaseNotes>
    implements Domain,
    EnabledAware {
        private Boolean enabled;
        private String configurationFile;
        private final GithubReleaser.ReleaseNotes immutable = new GithubReleaser.ReleaseNotes(){

            public String getConfigurationFile() {
                return configurationFile;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public GithubReleaser.ReleaseNotes asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(ReleaseNotes source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.configurationFile = this.merge(this.configurationFile, source.configurationFile);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public String getConfigurationFile() {
            return this.configurationFile;
        }

        public void setConfigurationFile(String configurationFile) {
            this.configurationFile = configurationFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("configurationFile", this.configurationFile);
            return map;
        }
    }
}

