/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.HttpAnnouncer;
import org.jreleaser.model.internal.announce.HttpAnnouncers;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class HttpAnnouncerValidator
extends Validator {
    private static final String DEFAULT_TPL = "src/jreleaser/templates";

    public static void validateHttpAnnouncers(JReleaserContext context, JReleaserContext.Mode mode, HttpAnnouncers http, Errors errors) {
        context.getLogger().debug("announce.http");
        Map<String, HttpAnnouncer> ha = http.getHttpAnnouncers();
        boolean enabled = false;
        for (Map.Entry<String, HttpAnnouncer> e : ha.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAnnounce() || !HttpAnnouncerValidator.validateHttpAnnouncer(context, http, e.getValue(), errors)) continue;
            enabled = true;
        }
        if (enabled) {
            http.setActive(Active.ALWAYS);
        } else {
            http.setActive(Active.NEVER);
        }
        if (!http.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
        }
    }

    public static boolean validateHttpAnnouncer(JReleaserContext context, HttpAnnouncers http, HttpAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.http." + announcer.getName());
        if (!announcer.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((String)announcer.getName())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            announcer.disable();
            return false;
        }
        if (StringUtils.isBlank((String)announcer.getUrl())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"http." + announcer.getName() + ".url"}));
        }
        if (null == announcer.getMethod()) {
            announcer.setMethod(Http.Method.PUT);
        }
        String baseKey = "announce.http." + announcer.getName() + ".";
        switch (announcer.resolveAuthorization()) {
            case BEARER: {
                announcer.setPassword(HttpAnnouncerValidator.checkProperty(context, "HTTP_" + Env.toVar((String)announcer.getName()) + "_PASSWORD", baseKey + "http.password", announcer.getPassword(), errors, context.isDryrun()));
                if (!StringUtils.isBlank((String)announcer.getBearerKeyword())) break;
                announcer.setBearerKeyword("Bearer");
                break;
            }
            case BASIC: {
                announcer.setUsername(HttpAnnouncerValidator.checkProperty(context, "HTTP_" + Env.toVar((String)announcer.getName()) + "_USERNAME", baseKey + "http.username", announcer.getUsername(), errors, context.isDryrun()));
                announcer.setPassword(HttpAnnouncerValidator.checkProperty(context, "HTTP_" + Env.toVar((String)announcer.getName()) + "_PASSWORD", baseKey + "http.password", announcer.getPassword(), errors, context.isDryrun()));
                break;
            }
        }
        String defaultPayloadTemplate = "src/jreleaser/templates/http/" + announcer.getName() + ".tpl";
        if (StringUtils.isBlank((String)announcer.getPayload()) && StringUtils.isBlank((String)announcer.getPayloadTemplate())) {
            if (Files.exists(context.getBasedir().resolve(defaultPayloadTemplate), new LinkOption[0])) {
                announcer.setPayloadTemplate(defaultPayloadTemplate);
            } else {
                announcer.setPayload(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getPayloadTemplate()) && !defaultPayloadTemplate.equals(announcer.getPayloadTemplate().trim()) && !Files.exists(context.getBasedir().resolve(announcer.getPayloadTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"http." + announcer.getName() + ".payloadTemplate", announcer.getPayloadTemplate()}));
        }
        HttpAnnouncerValidator.validateTimeout(announcer);
        return true;
    }
}

