/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.ChocolateyPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.CalVer;
import org.jreleaser.version.ChronVer;
import org.jreleaser.version.CustomVersion;
import org.jreleaser.version.JavaModuleVersion;
import org.jreleaser.version.JavaRuntimeVersion;
import org.jreleaser.version.SemanticVersion;

public abstract class ChocolateyPackagerValidator
extends Validator {
    public static void validateChocolatey(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, Errors errors) {
        Project project;
        context.getLogger().debug("distribution.{}.chocolatey", new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        ChocolateyPackager parentPackager = model.getPackagers().getChocolatey();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(project = context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".chocolatey"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.multiple.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), candidateArtifacts.stream().map(Artifact::getPath).collect(Collectors.toList())}));
            packager.disable();
            return;
        }
        ChocolateyPackagerValidator.validateCommitAuthor(packager, parentPackager);
        ChocolateyPackager.ChocolateyRepository bucket = packager.getBucket();
        bucket.resolveEnabled(model.getProject());
        ChocolateyPackagerValidator.validateTap(context, distribution, bucket, parentPackager.getBucket(), "chocolatey.bucket");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        ChocolateyPackagerValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)packager.getPackageVersion())) {
            packager.setPackageVersion(parentPackager.getPackageVersion());
            if (StringUtils.isBlank((String)packager.getPackageVersion())) {
                packager.setPackageVersion(model.getProject().getResolvedVersion());
            }
        }
        if (StringUtils.isBlank((String)packager.getUsername())) {
            packager.setUsername(service.getOwner());
        }
        if (!packager.isRemoteBuildSet() && parentPackager.isRemoteBuildSet()) {
            packager.setRemoteBuild(parentPackager.isRemoteBuild());
        }
        if (StringUtils.isBlank((String)packager.getTitle())) {
            packager.setTitle(parentPackager.getTitle());
        }
        if (StringUtils.isBlank((String)packager.getTitle())) {
            packager.setTitle(model.getProject().getName());
        }
        if (StringUtils.isBlank((String)packager.getIconUrl())) {
            packager.setIconUrl(parentPackager.getIconUrl());
        }
        if (StringUtils.isBlank((String)packager.getSource())) {
            packager.setSource(parentPackager.getSource());
        }
        if (StringUtils.isBlank((String)packager.getSource())) {
            packager.setSource("https://push.chocolatey.org/");
        }
        if (!packager.isRemoteBuild()) {
            if (StringUtils.isBlank((String)packager.getApiKey())) {
                packager.setApiKey(parentPackager.getApiKey());
            }
            packager.setApiKey(ChocolateyPackagerValidator.checkProperty(context, "CHOCOLATEY_API_KEY", "distributions." + distribution.getName() + ".chocolatey.internal.mutableKey", packager.getApiKey(), errors, context.isDryrun()));
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
        try {
            String packageVersion = Templates.resolveTemplate((String)packager.getPackageVersion(), context.getModel().props());
            switch (project.versionPattern().getType()) {
                case SEMVER: {
                    ChocolateyPackagerValidator.checkSemver(context, distribution, packager, SemanticVersion.of((String)packageVersion), errors);
                    break;
                }
                case JAVA_RUNTIME: {
                    ChocolateyPackagerValidator.checkJavaRuntime(context, distribution, packager, JavaRuntimeVersion.of((String)packageVersion), errors);
                    break;
                }
                case JAVA_MODULE: {
                    ChocolateyPackagerValidator.checkJavaModule(context, distribution, packager, JavaModuleVersion.of((String)packageVersion), errors);
                    break;
                }
                case CALVER: {
                    ChocolateyPackagerValidator.checkCalVer(context, distribution, packager, CalVer.of((String)project.versionPattern().getFormat(), (String)packageVersion), errors);
                    break;
                }
                case CHRONVER: {
                    ChocolateyPackagerValidator.checkChronVer(context, distribution, packager, ChronVer.of((String)packageVersion), errors);
                    break;
                }
                default: {
                    ChocolateyPackagerValidator.checkCustomVersion(context, distribution, packager, CustomVersion.of((String)packageVersion), errors);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            errors.configuration(RB.$((String)"validation_chocolatey_package_version", (Object[])new Object[]{packager.getPackageVersion()}));
        }
    }

    private static void checkSemver(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, SemanticVersion version, Errors errors) {
        boolean date;
        boolean integer;
        block7: {
            if (version.hasBuild()) {
                throw new IllegalArgumentException();
            }
            if (!version.hasTag() || "-".equals(version.getTagsep())) {
                return;
            }
            String tag = version.getTag();
            integer = false;
            date = false;
            try {
                Integer.parseInt(tag);
                integer = true;
                if (tag.length() != 8) break block7;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                try {
                    dateFormat.parse(tag);
                    date = true;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
        }
        if (!date && !integer) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkJavaRuntime(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, JavaRuntimeVersion version, Errors errors) {
        if (version.hasBuild()) {
            throw new IllegalArgumentException();
        }
        if (!version.hasPrerelease() && version.hasOptional()) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkJavaModule(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, JavaModuleVersion version, Errors errors) {
        if (version.hasBuild()) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkCalVer(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, CalVer version, Errors errors) {
    }

    private static void checkChronVer(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, ChronVer version, Errors errors) {
        ChronVer.Changeset changeset;
        if (version.hasChangeset() && ((changeset = version.getChangeset()).hasTag() || changeset.hasChange2())) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkCustomVersion(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, CustomVersion version, Errors errors) {
    }

    public static void postValidateChocolatey(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, Errors errors) {
        if (!packager.isEnabled()) {
            return;
        }
        context.getLogger().debug("distribution.{}.chocolatey", new Object[]{distribution.getName()});
        Project project = context.getModel().getProject();
        if (StringUtils.isBlank((String)project.getLinks().getLicense())) {
            errors.configuration(RB.$((String)"ERROR_project_no_license_url", (Object[])new Object[0]));
        }
    }
}

