/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.assemble.AssemblersValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class JavaArchiveAssemblerValidator {
    private JavaArchiveAssemblerValidator() {
    }

    public static void validateJavaArchive(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, JavaArchiveAssembler> archive = context.getModel().getAssemble().getJavaArchive();
        if (!archive.isEmpty()) {
            context.getLogger().debug("assemble.java-archive");
        }
        for (Map.Entry<String, JavaArchiveAssembler> e : archive.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            JavaArchiveAssemblerValidator.validateJavaArchive(context, mode, e.getValue(), errors);
        }
    }

    private static void validateJavaArchive(JReleaserContext context, JReleaserContext.Mode mode, JavaArchiveAssembler assembler, Errors errors) {
        context.getLogger().debug("assemble.java-archive.{}", new Object[]{assembler.getName()});
        Validator.resolveActivatable(context, (Activatable)assembler, CollectionUtils.listOf((Object[])new String[]{"assemble.java.archive." + assembler.getName(), "assemble.java.archive"}), "NEVER");
        if (!assembler.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)assembler.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"java-archive.name"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            assembler.disable();
            return;
        }
        if (StringUtils.isBlank((String)assembler.getArchiveName())) {
            assembler.setArchiveName("{{distributionName}}-{{projectVersion}}");
        }
        if (StringUtils.isBlank((String)assembler.getExecutable().getName())) {
            assembler.getExecutable().setName(assembler.getName());
        }
        if (StringUtils.isBlank((String)assembler.getExecutable().getWindowsExtension())) {
            assembler.getExecutable().setWindowsExtension("bat");
        }
        if (assembler.getFormats().isEmpty()) {
            assembler.addFormat(Archive.Format.ZIP);
        }
        if (null == assembler.getOptions().getTimestamp()) {
            assembler.getOptions().setTimestamp(context.getModel().resolveArchiveTimestamp());
        }
        if (assembler.getJars().isEmpty() && StringUtils.isBlank((String)assembler.getMainJar().getPath())) {
            errors.configuration(RB.$((String)"validation_java_archive_empty_jars", (Object[])new Object[]{assembler.getName()}));
        } else {
            Validator.validateGlobs(context, assembler.getJars(), "java-archive." + assembler.getName() + ".jars", errors);
        }
        AssemblersValidator.validateAssembler(context, mode, assembler, errors);
        context.getLogger().debug("assemble.java-archive.{}.java", new Object[]{assembler.getName()});
        Project project = context.getModel().getProject();
        if (StringUtils.isBlank((String)assembler.getJava().getMainModule())) {
            assembler.getJava().setMainModule(project.getJava().getMainModule());
        }
        if (StringUtils.isBlank((String)assembler.getJava().getMainClass())) {
            assembler.getJava().setMainClass(project.getJava().getMainClass());
        }
        assembler.getMainJar().resolveActiveAndSelected(context);
        boolean mainJarIsSet = StringUtils.isNotBlank((String)assembler.getMainJar().getPath());
        boolean mainClassIsSet = StringUtils.isNotBlank((String)assembler.getJava().getMainClass());
        if (!mainJarIsSet && !mainClassIsSet) {
            errors.configuration(RB.$((String)"validation_java_archive_main_jar_or_class_missing", (Object[])new Object[]{assembler.getName(), assembler.getName()}));
        }
    }
}

