/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.GiteaMavenDeployer;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class GiteaMavenDeployerValidator {
    private GiteaMavenDeployerValidator() {
    }

    public static void validateGiteaMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GiteaMavenDeployer> gitea = context.getModel().getDeploy().getMaven().getGitea();
        if (!gitea.isEmpty()) {
            context.getLogger().debug("deploy.maven.gitea");
        }
        for (Map.Entry<String, GiteaMavenDeployer> e : gitea.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateDeploy() && !mode.validateConfig()) continue;
            GiteaMavenDeployerValidator.validateGiteaMavenDeployer(context, e.getValue(), errors);
        }
    }

    private static void validateGiteaMavenDeployer(JReleaserContext context, GiteaMavenDeployer mavenDeployer, Errors errors) {
        MavenDeployersValidator.validateMavenDeployer(context, mavenDeployer, errors);
        if (!mavenDeployer.isEnabled()) {
            return;
        }
        BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
        mavenDeployer.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", "deploy.maven." + mavenDeployer.getType() + ".username", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", mavenDeployer.getType() + ".username"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", mavenDeployer.getUsername(), service.getUsername()));
        mavenDeployer.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", "deploy.maven." + mavenDeployer.getType() + ".password", "deploy.maven." + mavenDeployer.getType() + ".token", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", mavenDeployer.getType() + ".password", mavenDeployer.getType() + ".token"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getPassword(), service.getToken()));
        if (StringUtils.isBlank((String)mavenDeployer.getUsername())) {
            mavenDeployer.setUsername(context.getModel().getRelease().getReleaser().getUsername());
        }
    }
}

