/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.deploy.maven;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.deploy.Deployer;
import org.jreleaser.model.api.deploy.maven.Maven;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.deploy.maven.AbstractMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.ArtifactoryMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.AzureMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.GiteaMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.GitlabMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer;

public final class Maven
extends AbstractActivatable<Maven>
implements Domain,
Activatable {
    private static final long serialVersionUID = 3407667714827239350L;
    private final Map<String, ArtifactoryMavenDeployer> artifactory = new LinkedHashMap<String, ArtifactoryMavenDeployer>();
    private final Map<String, AzureMavenDeployer> azure = new LinkedHashMap<String, AzureMavenDeployer>();
    private final Map<String, GiteaMavenDeployer> gitea = new LinkedHashMap<String, GiteaMavenDeployer>();
    private final Map<String, GithubMavenDeployer> github = new LinkedHashMap<String, GithubMavenDeployer>();
    private final Map<String, GitlabMavenDeployer> gitlab = new LinkedHashMap<String, GitlabMavenDeployer>();
    private final Map<String, Nexus2MavenDeployer> nexus2 = new LinkedHashMap<String, Nexus2MavenDeployer>();
    private final Pomchecker pomchecker = new Pomchecker();
    @JsonIgnore
    private final org.jreleaser.model.api.deploy.maven.Maven immutable = new org.jreleaser.model.api.deploy.maven.Maven(){
        private static final long serialVersionUID = -8021098672645717824L;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.ArtifactoryMavenDeployer> artifactory;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.AzureMavenDeployer> azure;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.GiteaMavenDeployer> gitea;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.GithubMavenDeployer> github;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.GitlabMavenDeployer> gitlab;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer> nexus2;

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.ArtifactoryMavenDeployer> getArtifactory() {
            if (null == this.artifactory) {
                this.artifactory = Maven.this.artifactory.values().stream().map(ArtifactoryMavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.artifactory;
        }

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.AzureMavenDeployer> getAzure() {
            if (null == this.azure) {
                this.azure = Maven.this.azure.values().stream().map(AzureMavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.azure;
        }

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.GiteaMavenDeployer> getGitea() {
            if (null == this.gitea) {
                this.gitea = Maven.this.gitea.values().stream().map(GiteaMavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.gitea;
        }

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.GithubMavenDeployer> getGithub() {
            if (null == this.github) {
                this.github = Maven.this.github.values().stream().map(GithubMavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.github;
        }

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.GitlabMavenDeployer> getGitlab() {
            if (null == this.gitlab) {
                this.gitlab = Maven.this.gitlab.values().stream().map(GitlabMavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.gitlab;
        }

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer> getNexus2() {
            if (null == this.nexus2) {
                this.nexus2 = Maven.this.nexus2.values().stream().map(Nexus2MavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.nexus2;
        }

        public Maven.Pomchecker getPomchecker() {
            return Maven.this.pomchecker.asImmutable();
        }

        public Active getActive() {
            return Maven.this.getActive();
        }

        public boolean isEnabled() {
            return Maven.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Maven.this.asMap(full));
        }
    };

    public Maven() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.deploy.maven.Maven asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Maven source) {
        super.merge(source);
        this.setArtifactory(this.mergeModel(this.artifactory, source.artifactory));
        this.setAzure(this.mergeModel(this.azure, source.azure));
        this.setGitea(this.mergeModel(this.gitea, source.gitea));
        this.setGithub(this.mergeModel(this.github, source.github));
        this.setGitlab(this.mergeModel(this.gitlab, source.gitlab));
        this.setNexus2(this.mergeModel(this.nexus2, source.nexus2));
        this.setPomchecker(source.pomchecker);
    }

    @Override
    public boolean isSet() {
        return super.isSet() || !this.artifactory.isEmpty() || !this.azure.isEmpty() || !this.gitea.isEmpty() || !this.github.isEmpty() || !this.gitlab.isEmpty() || !this.nexus2.isEmpty();
    }

    public Optional<ArtifactoryMavenDeployer> getActiveArtifactory(String name) {
        return this.artifactory.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<AzureMavenDeployer> getActiveAzure(String name) {
        return this.azure.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<GiteaMavenDeployer> getActiveGitea(String name) {
        return this.gitea.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<GithubMavenDeployer> getActiveGithub(String name) {
        return this.github.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<GitlabMavenDeployer> getActiveGitlab(String name) {
        return this.gitlab.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<Nexus2MavenDeployer> getActiveNexus2(String name) {
        return this.nexus2.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public List<ArtifactoryMavenDeployer> getActiveArtifactories() {
        return this.artifactory.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public List<AzureMavenDeployer> getActiveAzures() {
        return this.azure.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public List<? extends MavenDeployer> getActiveDeployers() {
        ArrayList<AbstractMavenDeployer> list = new ArrayList<AbstractMavenDeployer>();
        list.addAll(this.getActiveArtifactories());
        list.addAll(this.getActiveAzures());
        list.addAll(this.getActiveGiteas());
        list.addAll(this.getActiveGithubs());
        list.addAll(this.getActiveGitlabs());
        list.addAll(this.getActiveNexus2s());
        return list;
    }

    public Map<String, ArtifactoryMavenDeployer> getArtifactory() {
        return this.artifactory;
    }

    public void setArtifactory(Map<String, ArtifactoryMavenDeployer> artifactory) {
        this.artifactory.clear();
        this.artifactory.putAll(artifactory);
    }

    public void addArtifactory(ArtifactoryMavenDeployer artifactory) {
        this.artifactory.put(artifactory.getName(), artifactory);
    }

    public Map<String, AzureMavenDeployer> getAzure() {
        return this.azure;
    }

    public void setAzure(Map<String, AzureMavenDeployer> azure) {
        this.azure.clear();
        this.azure.putAll(azure);
    }

    public void addAzure(AzureMavenDeployer azure) {
        this.azure.put(azure.getName(), azure);
    }

    public List<GiteaMavenDeployer> getActiveGiteas() {
        return this.gitea.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GiteaMavenDeployer> getGitea() {
        return this.gitea;
    }

    public void setGitea(Map<String, GiteaMavenDeployer> gitea) {
        this.gitea.clear();
        this.gitea.putAll(gitea);
    }

    public void addGitea(GiteaMavenDeployer gitea) {
        this.gitea.put(gitea.getName(), gitea);
    }

    public List<GithubMavenDeployer> getActiveGithubs() {
        return this.github.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GithubMavenDeployer> getGithub() {
        return this.github;
    }

    public void setGithub(Map<String, GithubMavenDeployer> github) {
        this.github.clear();
        this.github.putAll(github);
    }

    public void addGithub(GithubMavenDeployer github) {
        this.github.put(github.getName(), github);
    }

    public List<GitlabMavenDeployer> getActiveGitlabs() {
        return this.gitlab.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GitlabMavenDeployer> getGitlab() {
        return this.gitlab;
    }

    public void setGitlab(Map<String, GitlabMavenDeployer> gitlab) {
        this.gitlab.clear();
        this.gitlab.putAll(gitlab);
    }

    public void addGitlab(GitlabMavenDeployer gitlab) {
        this.gitlab.put(gitlab.getName(), gitlab);
    }

    public List<Nexus2MavenDeployer> getActiveNexus2s() {
        return this.nexus2.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Nexus2MavenDeployer> getNexus2() {
        return this.nexus2;
    }

    public void setNexus2(Map<String, Nexus2MavenDeployer> nexus2) {
        this.nexus2.clear();
        this.nexus2.putAll(nexus2);
    }

    public void addNexus2(Nexus2MavenDeployer nexus2) {
        this.nexus2.put(nexus2.getName(), nexus2);
    }

    public Pomchecker getPomchecker() {
        return this.pomchecker;
    }

    public void setPomchecker(Pomchecker pomchecker) {
        this.pomchecker.merge(pomchecker);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List nexus2;
        List gitlab;
        List github;
        List gitea;
        List azure;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("pomchecker", this.pomchecker.asMap(full));
        List artifactory = this.artifactory.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!artifactory.isEmpty()) {
            map.put("artifactory", artifactory);
        }
        if (!(azure = this.azure.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("azure", azure);
        }
        if (!(gitea = this.gitea.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("gitea", gitea);
        }
        if (!(github = this.github.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("github", github);
        }
        if (!(gitlab = this.gitlab.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("gitlab", gitlab);
        }
        if (!(nexus2 = this.nexus2.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("nexus2", nexus2);
        }
        return map;
    }

    public <A extends MavenDeployer<?>> Map<String, A> findMavenDeployersByType(String deployerType) {
        switch (deployerType) {
            case "artifactory": {
                return this.artifactory;
            }
            case "azure": {
                return this.azure;
            }
            case "gitea": {
                return this.gitea;
            }
            case "github": {
                return this.github;
            }
            case "gitlab": {
                return this.gitlab;
            }
            case "nexus2": {
                return this.nexus2;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends MavenDeployer<?>> List<A> findAllActiveMavenDeployers() {
        ArrayList<AbstractMavenDeployer> deployers = new ArrayList<AbstractMavenDeployer>();
        deployers.addAll(this.getActiveArtifactories());
        deployers.addAll(this.getActiveAzures());
        deployers.addAll(this.getActiveGiteas());
        deployers.addAll(this.getActiveGithubs());
        deployers.addAll(this.getActiveGitlabs());
        deployers.addAll(this.getActiveNexus2s());
        return deployers;
    }

    public static final class Pomchecker
    extends AbstractModelObject<Pomchecker>
    implements Domain {
        private static final long serialVersionUID = -3338690712854794960L;
        private String version;
        private Boolean failOnWarning;
        private Boolean failOnError;
        @JsonIgnore
        private final Maven.Pomchecker immutable = new Maven.Pomchecker(){
            private static final long serialVersionUID = 3245901294277040203L;

            public String getVersion() {
                return version;
            }

            public boolean isFailOnWarning() {
                return failOnWarning;
            }

            public boolean isFailOnError() {
                return failOnError;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Maven.Pomchecker asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Pomchecker source) {
            this.version = this.merge(this.version, source.version);
            this.failOnWarning = this.merge(this.failOnWarning, source.failOnWarning);
            this.failOnError = this.merge(this.failOnError, source.failOnError);
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean isFailOnWarning() {
            return this.failOnWarning != null && this.failOnWarning != false;
        }

        public boolean isFailOnWarningSet() {
            return this.failOnWarning != null;
        }

        public void setFailOnWarning(Boolean failOnWarning) {
            this.failOnWarning = failOnWarning;
        }

        public boolean isFailOnError() {
            return this.failOnError != null && this.failOnError != false;
        }

        public boolean isFailOnErrorSet() {
            return this.failOnError != null;
        }

        public void setFailOnError(Boolean failOnError) {
            this.failOnError = failOnError;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("version", this.version);
            map.put("failOnWarning", this.isFailOnWarning());
            map.put("failOnError", this.isFailOnError());
            return map;
        }
    }
}

