/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.deploy.maven.Maven;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.ArtifactoryMavenDeployerValidator;
import org.jreleaser.model.internal.validation.deploy.maven.AzureMavenDeployerValidator;
import org.jreleaser.model.internal.validation.deploy.maven.GiteaMavenDeployerValidator;
import org.jreleaser.model.internal.validation.deploy.maven.GithubMavenDeployerValidator;
import org.jreleaser.model.internal.validation.deploy.maven.GitlabMavenDeployerValidator;
import org.jreleaser.model.internal.validation.deploy.maven.Nexus2MavenDeployerValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.DefaultVersions;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class MavenDeployersValidator {
    private MavenDeployersValidator() {
    }

    public static void validateMavenDeployers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Maven maven = context.getModel().getDeploy().getMaven();
        context.getLogger().debug("deploy.maven");
        MavenDeployersValidator.validatePomchecker(context);
        ArtifactoryMavenDeployerValidator.validateArtifactoryMavenDeployer(context, mode, errors);
        AzureMavenDeployerValidator.validateAzureMavenDeployer(context, mode, errors);
        GiteaMavenDeployerValidator.validateGiteaMavenDeployer(context, mode, errors);
        GithubMavenDeployerValidator.validateGithubMavenDeployer(context, mode, errors);
        GitlabMavenDeployerValidator.validateGitlabMavenDeployer(context, mode, errors);
        Nexus2MavenDeployerValidator.validateNexus2MavenDeployer(context, mode, errors);
        if (mode.validateDeploy() || mode.validateConfig()) {
            boolean activeSet = maven.isActiveSet();
            Validator.resolveActivatable(context, (Activatable)maven, "deploy.maven", "ALWAYS");
            maven.resolveEnabledWithSnapshot(context.getModel().getProject());
            if (maven.isEnabled()) {
                boolean enabled;
                boolean bl = enabled = !maven.getActiveArtifactories().isEmpty() || !maven.getActiveAzures().isEmpty() || !maven.getActiveGiteas().isEmpty() || !maven.getActiveGithubs().isEmpty() || !maven.getActiveGitlabs().isEmpty() || !maven.getActiveNexus2s().isEmpty();
                if (!activeSet && !enabled) {
                    context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                    maven.disable();
                }
            }
        }
    }

    private static void validatePomchecker(JReleaserContext context) {
        Maven maven = context.getModel().getDeploy().getMaven();
        if (StringUtils.isBlank((String)maven.getPomchecker().getVersion())) {
            maven.getPomchecker().setVersion(DefaultVersions.getInstance().getPomcheckerVersion());
        }
        if (!maven.getPomchecker().isFailOnWarningSet()) {
            maven.getPomchecker().setFailOnWarning(true);
        }
        if (!maven.getPomchecker().isFailOnErrorSet()) {
            maven.getPomchecker().setFailOnError(true);
        }
    }

    static void validateMavenDeployer(JReleaserContext context, MavenDeployer<?> mavenDeployer, Errors errors) {
        context.getLogger().debug("deploy.maven.{}.{}", new Object[]{mavenDeployer.getType(), mavenDeployer.getName()});
        Validator.resolveActivatable(context, mavenDeployer, CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName(), "deploy.maven." + mavenDeployer.getType()}), "NEVER");
        if (!mavenDeployer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        String deployerPrefix = "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName();
        mavenDeployer.setUrl(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".url", "deploy.maven." + mavenDeployer.getType() + ".url", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".url", mavenDeployer.getType() + ".url"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".url", mavenDeployer.getUrl(), errors));
        if (StringUtils.isNotBlank((String)mavenDeployer.getUrl()) && mavenDeployer.getUrl().endsWith("/")) {
            mavenDeployer.setUrl(mavenDeployer.getUrl().substring(0, mavenDeployer.getUrl().length() - 1));
        }
        BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
        switch (mavenDeployer.resolveAuthorization()) {
            case BEARER: {
                mavenDeployer.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", "deploy.maven." + mavenDeployer.getType() + ".password", "deploy.maven." + mavenDeployer.getType() + ".token", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", mavenDeployer.getType() + ".password", mavenDeployer.getType() + ".token"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getPassword(), service.getToken()));
                break;
            }
            case BASIC: {
                mavenDeployer.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", "deploy.maven." + mavenDeployer.getType() + ".username", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", mavenDeployer.getType() + ".username"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", mavenDeployer.getUsername(), service.getUsername()));
                mavenDeployer.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", "deploy.maven." + mavenDeployer.getType() + ".password", "deploy.maven." + mavenDeployer.getType() + ".token", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", mavenDeployer.getType() + ".password", mavenDeployer.getType() + ".token"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getPassword(), service.getToken()));
                break;
            }
            case NONE: {
                errors.configuration(RB.$((String)"validation_value_cannot_be", (Object[])new Object[]{deployerPrefix + ".authorization", "NONE"}));
                context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
                mavenDeployer.disable();
            }
        }
        Validator.validateTimeout(mavenDeployer);
        if (mavenDeployer.getStagingRepositories().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{deployerPrefix + ".stagingDirectories"}));
        }
        if (mavenDeployer.isApplyMavenCentralRules() && !mavenDeployer.isSignSet()) {
            mavenDeployer.setSign(true);
        }
        if (mavenDeployer.isApplyMavenCentralRules() && !mavenDeployer.isChecksumsSet()) {
            mavenDeployer.setChecksums(true);
        }
        if (mavenDeployer.isApplyMavenCentralRules() && !mavenDeployer.isSourceJarSet()) {
            mavenDeployer.setSourceJar(true);
        }
        if (mavenDeployer.isApplyMavenCentralRules() && !mavenDeployer.isJavadocJarSet()) {
            mavenDeployer.setJavadocJar(true);
        }
        if (mavenDeployer.isApplyMavenCentralRules() && !mavenDeployer.isVerifyPomSet()) {
            mavenDeployer.setVerifyPom(true);
        }
        if (mavenDeployer.isSign() && !context.getModel().getSigning().isEnabled() && !context.isDryrun()) {
            errors.configuration(RB.$((String)"validation_maven_deployer_signing", (Object[])new Object[]{deployerPrefix}));
        }
        int index = 0;
        for (MavenDeployer.ArtifactOverride artifactOverride : mavenDeployer.getArtifactOverrides()) {
            if (StringUtils.isBlank((String)artifactOverride.getGroupId())) {
                artifactOverride.setGroupId(context.getModel().getProject().getJava().getGroupId());
            }
            if (StringUtils.isBlank((String)artifactOverride.getGroupId())) {
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{deployerPrefix + ".artifactOverrides[" + index + "].groupId"}));
            }
            if (StringUtils.isBlank((String)artifactOverride.getArtifactId())) {
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{deployerPrefix + ".artifactOverrides[" + index + "].artifactId"}));
            }
            ++index;
        }
    }
}

