/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.hooks.ScriptHook;

public final class ScriptHooks
extends AbstractActivatable<ScriptHooks>
implements Domain {
    private static final long serialVersionUID = -7608796505128220307L;
    private final List<ScriptHook> before = new ArrayList<ScriptHook>();
    private final List<ScriptHook> success = new ArrayList<ScriptHook>();
    private final List<ScriptHook> failure = new ArrayList<ScriptHook>();
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.ScriptHooks immutable = new org.jreleaser.model.api.hooks.ScriptHooks(){
        private static final long serialVersionUID = -2500325742137977937L;
        private List<? extends org.jreleaser.model.api.hooks.ScriptHook> before;
        private List<? extends org.jreleaser.model.api.hooks.ScriptHook> success;
        private List<? extends org.jreleaser.model.api.hooks.ScriptHook> failure;

        public List<? extends org.jreleaser.model.api.hooks.ScriptHook> getBefore() {
            if (null == this.before) {
                this.before = ScriptHooks.this.before.stream().map(ScriptHook::asImmutable).collect(Collectors.toList());
            }
            return this.before;
        }

        public List<? extends org.jreleaser.model.api.hooks.ScriptHook> getSuccess() {
            if (null == this.success) {
                this.success = ScriptHooks.this.success.stream().map(ScriptHook::asImmutable).collect(Collectors.toList());
            }
            return this.success;
        }

        public List<? extends org.jreleaser.model.api.hooks.ScriptHook> getFailure() {
            if (null == this.failure) {
                this.failure = ScriptHooks.this.failure.stream().map(ScriptHook::asImmutable).collect(Collectors.toList());
            }
            return this.failure;
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(ScriptHooks.this.getEnvironment());
        }

        public Active getActive() {
            return ScriptHooks.this.getActive();
        }

        public boolean isEnabled() {
            return ScriptHooks.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ScriptHooks.this.asMap(full));
        }
    };

    public ScriptHooks() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.hooks.ScriptHooks asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ScriptHooks source) {
        super.merge(source);
        this.setBefore(this.merge(this.before, source.before));
        this.setSuccess(this.merge(this.success, source.success));
        this.setFailure(this.merge(this.failure, source.failure));
        this.setEnvironment(this.merge(this.environment, source.getEnvironment()));
    }

    @Override
    public boolean isSet() {
        return super.isSet() || !this.before.isEmpty() || !this.success.isEmpty() || !this.failure.isEmpty();
    }

    public List<ScriptHook> getBefore() {
        return this.before;
    }

    public void setBefore(List<ScriptHook> before) {
        this.before.clear();
        this.before.addAll(before);
    }

    public List<ScriptHook> getSuccess() {
        return this.success;
    }

    public void setSuccess(List<ScriptHook> success) {
        this.success.clear();
        this.success.addAll(success);
    }

    public List<ScriptHook> getFailure() {
        return this.failure;
    }

    public void setFailure(List<ScriptHook> failure) {
        this.failure.clear();
        this.failure.addAll(failure);
    }

    public void addBefore(ScriptHook hook) {
        if (null != hook) {
            this.before.add(hook);
        }
    }

    public void addSuccess(ScriptHook hook) {
        if (null != hook) {
            this.success.add(hook);
        }
    }

    public void addFailure(ScriptHook hook) {
        if (null != hook) {
            this.failure.add(hook);
        }
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    public void addEnvironment(Map<String, String> environment) {
        this.environment.putAll(environment);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("environment", this.environment);
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (ScriptHook hook : this.getBefore()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("before", m);
        m = new LinkedHashMap();
        i = 0;
        for (ScriptHook hook : this.getSuccess()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("success", m);
        m = new LinkedHashMap();
        i = 0;
        for (ScriptHook hook : this.getFailure()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("failure", m);
        return map;
    }
}

