/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.ServiceLoader;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserModel;

public class JReleaserConfigLoader {
    public static JReleaserModel loadConfig(Path configFile) {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            JReleaserModel jReleaserModel;
            block11: {
                if (!parser.supports(configFile)) continue;
                try {
                    parser.validate(configFile);
                }
                catch (IOException e) {
                    throw new JReleaserException("Invalid config file. " + configFile, e);
                }
                InputStream inputStream = configFile.toUri().toURL().openStream();
                try {
                    jReleaserModel = parser.parse(inputStream);
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new JReleaserException("Unexpected error parsing config file. " + configFile, e);
                    }
                }
                inputStream.close();
            }
            return jReleaserModel;
        }
        throw new JReleaserException("Unsupported config format. " + configFile);
    }

    public static Map<String, String> loadProperties(Path file) throws IOException {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            if (!parser.supports(file)) continue;
            try (InputStream inputStream = file.toUri().toURL().openStream();){
                Map<String, String> map = parser.properties(inputStream);
                return map;
            }
        }
        throw new JReleaserException("Unsupported format. " + file);
    }
}

