/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.Java;
import org.jreleaser.model.Project;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

abstract class AbstractAssembler
implements Assembler {
    protected final Set<Artifact> outputs = new LinkedHashSet<Artifact>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Java java = new Java();
    private final String type;
    protected String name;
    protected boolean enabled;
    protected Active active;
    protected String executable;
    protected String templateDirectory;
    protected Boolean exported;

    protected AbstractAssembler(String type) {
        this.type = type;
    }

    void setAll(AbstractAssembler assembler) {
        this.active = assembler.active;
        this.enabled = assembler.enabled;
        this.exported = assembler.exported;
        this.name = assembler.name;
        this.executable = assembler.executable;
        this.templateDirectory = assembler.templateDirectory;
        this.setOutputs(assembler.outputs);
        this.setJava(assembler.java);
        this.setExtraProperties(assembler.extraProperties);
    }

    @Override
    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("distributionName", this.name);
        props.put("distributionExecutable", this.executable);
        props.putAll(this.java.getResolvedExtraProperties());
        CollectionUtils.safePut((String)"distributionJavaGroupId", (Object)this.java.getGroupId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaArtifactId", (Object)this.java.getArtifactId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaMainClass", (Object)this.java.getMainClass(), props, (boolean)true);
        if (StringUtils.isNotBlank((String)this.java.getVersion())) {
            props.put("distributionJavaVersion", this.java.getVersion());
            Version jv = Version.of((String)this.java.getVersion());
            CollectionUtils.safePut((String)"distributionJavaVersionMajor", (Object)jv.getMajor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionMinor", (Object)jv.getMinor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionPatch", (Object)jv.getPatch(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionTag", (Object)jv.getTag(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionBuild", (Object)jv.getBuild(), props, (boolean)true);
        } else {
            props.put("distributionJavaVersion", "");
            props.put("distributionJavaVersionMajor", "");
            props.put("distributionJavaVersionMinor", "");
            props.put("distributionJavaVersionPatch", "");
            props.put("distributionJavaVersionTag", "");
            props.put("distributionJavaVersionBuild", "");
        }
        return props;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public boolean isExported() {
        return this.exported == null || this.exported != false;
    }

    @Override
    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(String executable) {
        this.executable = executable;
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.active = Active.of(str);
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public Set<Artifact> getOutputs() {
        return Artifact.sortArtifacts(this.outputs);
    }

    @Override
    public void setOutputs(Set<Artifact> output) {
        this.outputs.clear();
        this.outputs.addAll(output);
    }

    @Override
    public void addOutput(Artifact artifact) {
        if (null != artifact) {
            this.outputs.add(artifact);
        }
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Java getJava() {
        return this.java;
    }

    @Override
    public void setJava(Java java) {
        this.java.setAll(java);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public String getPrefix() {
        return this.getType();
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("exported", this.isExported());
        props.put("active", (Object)this.active);
        props.put("executable", this.executable);
        props.put("templateDirectory", this.templateDirectory);
        this.asMap(full, props);
        props.put("extraProperties", this.getResolvedExtraProperties());
        if (this.java.isEnabled()) {
            props.put("java", this.java.asMap(full));
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

