/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.GitService;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public abstract class AbstractRepositoryTap
implements RepositoryTap {
    protected String basename;
    protected String owner;
    protected String name;
    protected String branch;
    protected String username;
    protected String token;

    AbstractRepositoryTap(String basename) {
        this.basename = basename;
    }

    @Override
    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    void setAll(AbstractRepositoryTap tap) {
        this.owner = tap.owner;
        this.name = tap.name;
        this.branch = tap.branch;
        this.username = tap.username;
        this.token = tap.token;
    }

    @Override
    public String getCanonicalRepoName() {
        return this.owner + "/" + this.getResolvedName();
    }

    @Override
    public String getResolvedName() {
        if (StringUtils.isNotBlank((String)this.name)) {
            return this.name;
        }
        return this.basename;
    }

    @Override
    public String getResolvedUsername(GitService service) {
        return Env.resolve((String)(Env.toVar((String)(this.basename + "_" + service.getServiceName())) + "_USERNAME"), (String)this.username);
    }

    @Override
    public String getResolvedToken(GitService service) {
        return Env.resolve((String)(Env.toVar((String)(this.basename + "_" + service.getServiceName())) + "_TOKEN"), (String)this.token);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("owner", this.owner);
        map.put("name", this.getResolvedName());
        map.put("branch", this.branch);
        map.put("username", this.username);
        map.put("token", StringUtils.isNotBlank((String)this.token) ? "************" : "**unset**");
        return map;
    }
}

