/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Uploader;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

abstract class AbstractUploader
implements Uploader {
    protected final String type;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    protected String name;
    protected boolean enabled;
    protected Active active;
    private String uploadUrl;
    private String downloadUrl;
    private int connectTimeout;
    private int readTimeout;
    private Boolean artifacts;
    private Boolean files;
    private Boolean signatures;

    protected AbstractUploader(String type) {
        this.type = type;
    }

    void setAll(AbstractUploader uploader) {
        this.active = uploader.active;
        this.enabled = uploader.enabled;
        this.name = uploader.name;
        this.uploadUrl = uploader.uploadUrl;
        this.downloadUrl = uploader.downloadUrl;
        this.connectTimeout = uploader.connectTimeout;
        this.readTimeout = uploader.readTimeout;
        this.artifacts = uploader.artifacts;
        this.files = uploader.files;
        this.signatures = uploader.signatures;
        this.setExtraProperties(uploader.extraProperties);
    }

    @Override
    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(context, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return MustacheUtils.applyTemplate((String)this.uploadUrl, p);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(context, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return MustacheUtils.applyTemplate((String)this.downloadUrl, p);
    }

    @Override
    public String getPrefix() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        if (project.isSnapshot() && !this.isSnapshotSupported()) {
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Override
    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.active = Active.of(str);
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Boolean isArtifacts() {
        return this.artifacts == null || this.artifacts != false;
    }

    @Override
    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    @Override
    public boolean isArtifactsSet() {
        return this.artifacts != null;
    }

    @Override
    public Boolean isFiles() {
        return this.files == null || this.files != false;
    }

    @Override
    public void setFiles(Boolean files) {
        this.files = files;
    }

    @Override
    public boolean isFilesSet() {
        return this.files != null;
    }

    @Override
    public Boolean isSignatures() {
        return this.signatures == null || this.signatures != false;
    }

    @Override
    public void setSignatures(Boolean signatures) {
        this.signatures = signatures;
    }

    @Override
    public boolean isSignaturesSet() {
        return this.signatures != null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", (Object)this.active);
        props.put("uploadUrl", this.uploadUrl);
        props.put("downloadUrl", this.downloadUrl);
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        props.put("artifacts", this.isArtifacts());
        props.put("files", this.isFiles());
        props.put("signatures", this.isSignatures());
        this.asMap(props, full);
        props.put("extraProperties", this.getResolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(Map<String, Object> var1, boolean var2);

    @Override
    public List<String> resolveSkipKeys() {
        String skipUpload = "skipUpload";
        String skipUploadByType = skipUpload + StringUtils.capitalize((String)this.type);
        String skipUploadByName = skipUploadByType + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.name);
        return Arrays.asList(skipUpload, skipUploadByType, skipUploadByName);
    }

    @Override
    public Map<String, Object> artifactProps(JReleaserContext context, Artifact artifact) {
        Map<String, Object> props = context.props();
        String platform = StringUtils.isNotBlank((String)artifact.getPlatform()) ? artifact.getPlatform() : "";
        Map<String, Object> artifactProps = artifact.getResolvedExtraProperties("artifact");
        artifactProps.keySet().stream().filter(k -> !props.containsKey(k)).filter(k -> !k.startsWith("artifactSkip")).forEach(k -> props.put((String)k, artifactProps.get(k)));
        String artifactFileName = artifact.getEffectivePath(context).getFileName().toString();
        props.put("artifactPlatform", platform);
        props.put("artifactFileName", artifactFileName);
        props.put("artifactName", StringUtils.getFilename((String)artifactFileName));
        return props;
    }
}

