/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractAssembler;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.Domain;
import org.jreleaser.model.EnabledAware;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Jlink;
import org.jreleaser.model.NativeImage;
import org.jreleaser.util.StringUtils;

public class Assemble
implements Domain,
EnabledAware {
    private final Map<String, Jlink> jlink = new LinkedHashMap<String, Jlink>();
    private final Map<String, NativeImage> nativeImage = new LinkedHashMap<String, NativeImage>();
    private Boolean enabled;

    void setAll(Assemble assemble) {
        this.enabled = assemble.enabled;
        this.setJlink(assemble.jlink);
        this.setNativeImage(assemble.nativeImage);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public List<Jlink> getActiveJlinks() {
        return this.jlink.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Jlink> getJlink() {
        return this.jlink;
    }

    public void setJlink(Map<String, Jlink> jlink) {
        this.jlink.clear();
        this.jlink.putAll(jlink);
    }

    public void addJlink(Jlink jlink) {
        this.jlink.put(jlink.getName(), jlink);
    }

    public Jlink findJlink(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException("Jlink name must not be blank");
        }
        if (this.jlink.containsKey(name)) {
            return this.jlink.get(name);
        }
        throw new JReleaserException("Jlink '" + name + "' not found");
    }

    public List<NativeImage> getActiveNativeImages() {
        return this.nativeImage.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, NativeImage> getNativeImage() {
        return this.nativeImage;
    }

    public void setNativeImage(Map<String, NativeImage> nativeImage) {
        this.nativeImage.clear();
        this.nativeImage.putAll(nativeImage);
    }

    public void addNativeImage(NativeImage nativeImage) {
        this.nativeImage.put(nativeImage.getName(), nativeImage);
    }

    public NativeImage findNativeImage(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException("NativeImage name must not be blank");
        }
        if (this.nativeImage.containsKey(name)) {
            return this.nativeImage.get(name);
        }
        throw new JReleaserException("NativeImage '" + name + "' not found");
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List nativeImage;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        List jlink = this.jlink.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!jlink.isEmpty()) {
            map.put("jlink", jlink);
        }
        if (!(nativeImage = this.nativeImage.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("nativeImage", nativeImage);
        }
        return map;
    }

    public <A extends Assembler> Map<String, A> findAssemblersByType(String assemblerName) {
        switch (assemblerName) {
            case "jlink": {
                return this.jlink;
            }
            case "native-image": {
                return this.nativeImage;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends Assembler> Collection<A> findAllAssemblers() {
        ArrayList<AbstractAssembler> assemblers = new ArrayList<AbstractAssembler>();
        assemblers.addAll(this.getActiveJlinks());
        assemblers.addAll(this.getActiveNativeImages());
        return assemblers;
    }
}

