/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Uploader;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class HttpUploader
extends AbstractUploader {
    public static final String TYPE = "http";
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String username;
    private String password;
    private Uploader.Authorization authorization;
    private Uploader.Method method;

    public HttpUploader() {
        super(TYPE);
    }

    void setAll(HttpUploader http) {
        super.setAll(http);
        this.username = http.username;
        this.password = http.password;
        this.authorization = http.authorization;
        this.method = http.method;
        this.setHeaders(http.headers);
    }

    public Uploader.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = Uploader.Authorization.NONE;
        }
        return this.authorization;
    }

    public String getResolvedUsername() {
        return Env.resolve((String)("HTTP_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    public String getResolvedPassword() {
        return Env.resolve((String)("HTTP_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public String getTarget() {
        System.out.println("http.target has been deprecated since 0.6.0 and will be removed in the future. Use http.uploadUrl instead");
        return this.getUploadUrl();
    }

    @Deprecated
    public void setTarget(String target) {
        System.out.println("http.target has been deprecated since 0.6.0 and will be removed in the future. Use http.uploadUrl instead");
        this.setUploadUrl(target);
    }

    public Uploader.Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Uploader.Authorization authorization) {
        this.authorization = authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = Uploader.Authorization.of(authorization);
    }

    public Uploader.Method getMethod() {
        return this.method;
    }

    public void setMethod(Uploader.Method method) {
        this.method = method;
    }

    public void setMethod(String method) {
        this.method = Uploader.Method.of(method);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public void addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("authorization", (Object)this.authorization);
        props.put("method", (Object)this.method);
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("headers", this.headers);
    }
}

