/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPException;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserCommand;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.JReleaserModelResolver;
import org.jreleaser.model.JReleaserModelValidator;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.Project;
import org.jreleaser.model.Signing;
import org.jreleaser.model.releaser.spi.Releaser;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;
import org.jreleaser.util.signing.FilesKeyring;
import org.jreleaser.util.signing.InMemoryKeyring;
import org.jreleaser.util.signing.Keyring;
import org.jreleaser.util.signing.SigningException;

public class JReleaserContext {
    private final JReleaserLogger logger;
    private final JReleaserModel model;
    private final Path basedir;
    private final Path outputDirectory;
    private final boolean dryrun;
    private final boolean gitRootSearch;
    private final Mode mode;
    private final Configurer configurer;
    private final Errors errors = new Errors();
    private final List<String> selectedPlatforms = new ArrayList<String>();
    private String distributionName;
    private String toolName;
    private String announcerName;
    private String uploaderName;
    private String uploaderType;
    private String assemblerName;
    private String changelog;
    private Releaser releaser;
    private JReleaserCommand command;

    public JReleaserContext(JReleaserLogger logger, Configurer configurer, Mode mode, JReleaserModel model, Path basedir, Path outputDirectory, boolean dryrun, boolean gitRootSearch, List<String> selectedPlatforms) {
        this.logger = logger;
        this.configurer = configurer;
        this.mode = mode;
        this.model = model;
        this.basedir = basedir;
        this.outputDirectory = outputDirectory;
        this.dryrun = dryrun;
        this.gitRootSearch = gitRootSearch;
        this.selectedPlatforms.addAll(selectedPlatforms.stream().filter(PlatformUtils::isSupported).collect(Collectors.toList()));
        ArrayList<String> unmatchedPlatforms = new ArrayList<String>(selectedPlatforms);
        unmatchedPlatforms.removeAll(this.selectedPlatforms);
        if (!unmatchedPlatforms.isEmpty()) {
            logger.warn("Platform selection is in effect");
            logger.error("The following platforms did not match: {}", new Object[]{unmatchedPlatforms});
            logger.error("Please use `${name}` or `${name}-${arch}` from{}        name = {}{}        arch = {}", new Object[]{System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()});
            throw new JReleaserException("Unmatched platforms: " + unmatchedPlatforms);
        }
        if (!this.selectedPlatforms.isEmpty()) {
            logger.warn("Platform selection is in effect");
            logger.warn("Artifacts will be filtered by platform matching: {}", new Object[]{this.selectedPlatforms});
        }
    }

    public Path relativize(Path basedir, Path other) {
        return basedir.toAbsolutePath().relativize(other.toAbsolutePath());
    }

    public Path relativizeToBasedir(Path other) {
        return this.relativize(this.basedir, other);
    }

    public Errors validateModel() {
        if (this.errors.hasErrors()) {
            return this.errors;
        }
        this.model.getEnvironment().initProps(this);
        this.logger.info("Validating configuration");
        if (this.mode == Mode.FULL) {
            this.adjustDistributions();
        }
        try {
            JReleaserModelValidator.validate(this, this.mode, this.errors);
        }
        catch (Exception e) {
            this.logger.trace((Throwable)e);
            this.errors.configuration(e.toString());
        }
        if (this.errors.hasErrors()) {
            this.logger.error("== JReleaser ==");
            this.errors.logErrors(this.logger);
        }
        return this.errors;
    }

    private void adjustDistributions() {
        this.logger.debug("adjusting distributions with assemblies");
        try {
            JReleaserModelValidator.validate(this, Mode.ASSEMBLE, this.errors);
            JReleaserModelResolver.resolve(this, this.errors);
        }
        catch (Exception e) {
            this.logger.trace((Throwable)e);
            this.errors.configuration(e.toString());
        }
        for (Assembler assembler : this.model.getAssemble().findAllAssemblers()) {
            if (!assembler.isExported()) continue;
            Distribution distribution = this.model.getDistributions().get(assembler.getName());
            if (null == distribution) {
                distribution = new Distribution();
                distribution.setType(assembler.getType());
                distribution.setName(assembler.getName());
                this.model.getDistributions().put(assembler.getName(), distribution);
            }
            distribution.setName(assembler.getName());
            distribution.setType(assembler.getType());
            distribution.setExecutable(assembler.getExecutable());
            distribution.setActive(assembler.getActive());
            distribution.setJava(assembler.getJava());
            this.mergeArtifacts(assembler, distribution);
            LinkedHashMap<String, Object> extraProperties = new LinkedHashMap<String, Object>(distribution.getExtraProperties());
            extraProperties.putAll(assembler.getExtraProperties());
            distribution.mergeExtraProperties(extraProperties);
        }
    }

    private void mergeArtifacts(Assembler assembler, Distribution distribution) {
        for (Artifact incoming : assembler.getOutputs()) {
            Optional<Artifact> artifact = distribution.getArtifacts().stream().filter(a -> {
                Path p1 = incoming.getResolvedPath(this, assembler);
                Path p2 = a.getResolvedPath(this, distribution);
                return p1.equals(p2);
            }).findFirst();
            if (artifact.isPresent()) {
                artifact.get().merge(incoming);
                continue;
            }
            distribution.addArtifact(incoming);
        }
    }

    public boolean isPlatformSelected(Artifact artifact) {
        return this.isPlatformSelected(artifact.getPlatform());
    }

    public boolean isPlatformSelected(String platform) {
        if (StringUtils.isBlank((String)platform) || this.selectedPlatforms.isEmpty()) {
            return true;
        }
        return this.selectedPlatforms.stream().anyMatch(selected -> PlatformUtils.isCompatible((String)selected, (String)platform));
    }

    public JReleaserLogger getLogger() {
        return this.logger;
    }

    public Configurer getConfigurer() {
        return this.configurer;
    }

    public Mode getMode() {
        return this.mode;
    }

    public JReleaserModel getModel() {
        return this.model;
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public Path getChecksumsDirectory() {
        return this.outputDirectory.resolve("checksums");
    }

    public Path getSignaturesDirectory() {
        return this.outputDirectory.resolve("signatures");
    }

    public Path getPrepareDirectory() {
        return this.outputDirectory.resolve("prepare");
    }

    public Path getPackageDirectory() {
        return this.outputDirectory.resolve("package");
    }

    public Path getAssembleDirectory() {
        return this.outputDirectory.resolve("assemble");
    }

    public Path getArtifactsDirectory() {
        return this.outputDirectory.resolve("artifacts");
    }

    public boolean isDryrun() {
        return this.dryrun;
    }

    public boolean isGitRootSearch() {
        return this.gitRootSearch;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public void setChangelog(String changelog) {
        this.changelog = changelog;
    }

    public Releaser getReleaser() {
        return this.releaser;
    }

    public void setReleaser(Releaser releaser) {
        this.releaser = releaser;
    }

    public boolean hasDistributionName() {
        return StringUtils.isNotBlank((String)this.distributionName);
    }

    public boolean hasToolName() {
        return StringUtils.isNotBlank((String)this.toolName);
    }

    public boolean hasAnnouncerName() {
        return StringUtils.isNotBlank((String)this.announcerName);
    }

    public boolean hasUploaderName() {
        return StringUtils.isNotBlank((String)this.uploaderName);
    }

    public boolean hasUploaderType() {
        return StringUtils.isNotBlank((String)this.uploaderType);
    }

    public boolean hasAssemblerName() {
        return StringUtils.isNotBlank((String)this.assemblerName);
    }

    public String getDistributionName() {
        return this.distributionName;
    }

    public void setDistributionName(String distributionName) {
        this.distributionName = distributionName;
    }

    public String getToolName() {
        return this.toolName;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public String getAnnouncerName() {
        return this.announcerName;
    }

    public void setAnnouncerName(String announcerName) {
        this.announcerName = announcerName;
    }

    public String getUploaderName() {
        return this.uploaderName;
    }

    public void setUploaderName(String uploaderName) {
        this.uploaderName = uploaderName;
    }

    public String getUploaderType() {
        return this.uploaderType;
    }

    public void setUploaderType(String uploaderType) {
        this.uploaderType = uploaderType;
    }

    public String getAssemblerName() {
        return this.assemblerName;
    }

    public void setAssemblerName(String assemblerName) {
        this.assemblerName = assemblerName;
    }

    public JReleaserCommand getCommand() {
        return this.command;
    }

    public void setCommand(JReleaserCommand command) {
        this.command = command;
    }

    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(this.model.props());
        props.put("outputDirectory", this.getOutputDirectory());
        props.put("checksumDirectory", this.getChecksumsDirectory());
        props.put("signaturesDirectory", this.getSignaturesDirectory());
        props.put("prepareDirectory", this.getPrepareDirectory());
        props.put("packageDirectory", this.getPackageDirectory());
        props.put("assembleDirectory", this.getAssembleDirectory());
        props.put("artifactsDirectory", this.getArtifactsDirectory());
        return props;
    }

    public String toString() {
        return "JReleaserContext[basedir=" + this.basedir.toAbsolutePath() + ", outputDirectory=" + this.outputDirectory.toAbsolutePath() + ", dryrun=" + this.dryrun + ", gitRootSearch=" + this.gitRootSearch + ", mode=" + (Object)((Object)this.mode) + "]";
    }

    public void report() {
        Project project = this.model.getProject();
        SortedProperties props = new SortedProperties();
        props.put("timestamp", this.model.getTimestamp());
        props.put("commitShortHash", this.model.getCommit().getShortHash());
        props.put("commitFullHash", this.model.getCommit().getFullHash());
        props.put("projectName", project.getName());
        props.put("projectVersion", project.getVersion());
        props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
        GitService gitService = this.model.getRelease().getGitService();
        props.put("tagName", gitService.getEffectiveTagName(this.model));
        if (gitService.isReleaseSupported()) {
            props.put("releaseName", gitService.getEffectiveReleaseName());
            props.put("milestoneName", gitService.getMilestone().getEffectiveName());
        }
        props.put("javaVersion", System.getProperty("java.version"));
        Map<String, Object> resolvedExtraProperties = project.getResolvedExtraProperties();
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionMajor")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionMinor")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionPatch")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionNumber")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionPrerelease")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionTag")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionBuild")), resolvedExtraProperties, (Properties)props);
        Path output = this.getOutputDirectory().resolve("output.properties");
        try (FileOutputStream out = new FileOutputStream(output.toFile());){
            this.logger.info("Writing output properties to {}", new Object[]{this.relativizeToBasedir(output)});
            props.store(out, "JReleaser " + JReleaserVersion.getPlainVersion());
        }
        catch (IOException ignored) {
            this.logger.warn("Could not write output properties to {}", new Object[]{this.relativizeToBasedir(output)});
        }
    }

    public void nag(String version, String message) {
        this.logger.warn(message + " since {}. This warning will become an error in a future release.", new Object[]{version});
    }

    public Keyring createKeyring() throws SigningException {
        try {
            if (this.model.getSigning().getMode() == Signing.Mode.FILE) {
                return new FilesKeyring(this.basedir.resolve(this.model.getSigning().getResolvedPublicKey()), this.basedir.resolve(this.model.getSigning().getResolvedSecretKey())).initialize(this.model.getSigning().isArmored().booleanValue());
            }
            return new InMemoryKeyring(this.model.getSigning().getResolvedPublicKey().getBytes(), this.model.getSigning().getResolvedSecretKey().getBytes()).initialize(this.model.getSigning().isArmored().booleanValue());
        }
        catch (IOException | PGPException e) {
            throw new SigningException("Could not initialize keyring", e);
        }
    }

    private static class IteratorEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<? extends E> iterator;

        public IteratorEnumeration(Iterator<? extends E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }

    private static class SortedProperties
    extends Properties {
        private SortedProperties() {
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            int javaMajorVersion = Version.javaMajorVersion();
            if (javaMajorVersion < 11) {
                return super.entrySet();
            }
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (Object k : this.keySet()) {
                map.put(String.valueOf(k), this.get(k));
            }
            return map.entrySet();
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            int javaMajorVersion = Version.javaMajorVersion();
            if (javaMajorVersion >= 11) {
                return super.keys();
            }
            Set<Object> keySet = this.keySet();
            ArrayList<String> keys = new ArrayList<String>(keySet.size());
            for (Object key : keySet) {
                keys.add(key.toString());
            }
            Collections.sort(keys);
            return new IteratorEnumeration<Object>(keys.iterator());
        }
    }

    public static enum Configurer {
        CLI("CLI flags"),
        CLI_YAML("CLI yaml DSL"),
        CLI_TOML("CLI toml DSL"),
        CLI_JSON("CLI json DSL"),
        MAVEN("Maven DSL"),
        GRADLE("Gradle DSL");

        private final String dsl;

        private Configurer(String dsl) {
            this.dsl = dsl;
        }

        public String toString() {
            return this.dsl;
        }
    }

    public static enum Mode {
        ASSEMBLE,
        FULL,
        CHANGELOG;

    }
}

