/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractAssembler;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Glob;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class Jlink
extends AbstractAssembler {
    public static final String NAME = "jlink";
    private final Set<Artifact> targetJdks = new LinkedHashSet<Artifact>();
    private final Set<String> moduleNames = new LinkedHashSet<String>();
    private final List<String> args = new ArrayList<String>();
    private final Artifact jdk = new Artifact();
    private final Artifact mainJar = new Artifact();
    private final List<Glob> jars = new ArrayList<Glob>();
    private final List<Glob> files = new ArrayList<Glob>();
    private String imageName;
    private String imageNameTransform;
    private String moduleName;

    public Jlink() {
        super(NAME);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.JLINK;
    }

    void setAll(Jlink jlink) {
        super.setAll(jlink);
        this.imageName = jlink.imageName;
        this.imageNameTransform = jlink.imageNameTransform;
        this.moduleName = jlink.moduleName;
        this.setJdk(jlink.jdk);
        this.setMainJar(jlink.mainJar);
        this.setTargetJdks(jlink.targetJdks);
        this.setModuleNames(jlink.moduleNames);
        this.setArgs(jlink.args);
        this.setJars(jlink.jars);
        this.setFiles(jlink.files);
    }

    public String getResolvedImageName(JReleaserContext context) {
        Map<String, Object> props = context.props();
        props.putAll(this.props());
        return MustacheUtils.applyTemplate((String)this.imageName, props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        Map<String, Object> props = context.props();
        props.putAll(this.props());
        return MustacheUtils.applyTemplate((String)this.imageNameTransform, props);
    }

    public Artifact getJdk() {
        return this.jdk;
    }

    public void setJdk(Artifact jdk) {
        this.jdk.setAll(jdk);
    }

    public Artifact getMainJar() {
        return this.mainJar;
    }

    public void setMainJar(Artifact mainJar) {
        this.mainJar.setAll(mainJar);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.imageNameTransform = imageNameTransform;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public Set<Artifact> getTargetJdks() {
        return Artifact.sortArtifacts(this.targetJdks);
    }

    public void setTargetJdks(Set<Artifact> targetJdks) {
        this.targetJdks.clear();
        this.targetJdks.addAll(targetJdks);
    }

    public void addTargetJdks(Set<Artifact> targetJdks) {
        this.targetJdks.addAll(targetJdks);
    }

    public void addTargetJdk(Artifact jdk) {
        if (null != jdk) {
            this.targetJdks.add(jdk);
        }
    }

    public Set<String> getModuleNames() {
        return this.moduleNames;
    }

    public void setModuleNames(Set<String> moduleNames) {
        this.moduleNames.clear();
        this.moduleNames.addAll(moduleNames);
    }

    public void addModuleNames(List<String> moduleNames) {
        this.moduleNames.addAll(moduleNames);
    }

    public void addModuleName(String moduleName) {
        if (StringUtils.isNotBlank((String)moduleName)) {
            this.moduleNames.add(moduleName.trim());
        }
    }

    public void removeModuleName(String moduleName) {
        if (StringUtils.isNotBlank((String)moduleName)) {
            this.moduleNames.remove(moduleName.trim());
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public void addArgs(List<String> args) {
        this.args.addAll(args);
    }

    public void addArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.add(arg.trim());
        }
    }

    public void removeArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.remove(arg.trim());
        }
    }

    public List<Glob> getJars() {
        return this.jars;
    }

    public void setJars(List<Glob> jars) {
        this.jars.clear();
        this.jars.addAll(jars);
    }

    public void addJars(List<Glob> jars) {
        this.jars.addAll(jars);
    }

    public void addJar(Glob jar) {
        if (null != jar) {
            this.jars.add(jar);
        }
    }

    public List<Glob> getFiles() {
        return this.files;
    }

    public void setFiles(List<Glob> files) {
        this.files.clear();
        this.files.addAll(files);
    }

    public void addFiles(List<Glob> files) {
        this.files.addAll(files);
    }

    public void addFile(Glob file) {
        if (null != file) {
            this.files.add(file);
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("moduleName", this.moduleName);
        props.put("moduleNames", this.moduleNames);
        props.put("args", this.args);
        LinkedHashMap<String, Map<String, Object>> mappedJdks = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact targetJdk : this.getTargetJdks()) {
            mappedJdks.put("jdk " + i++, targetJdk.asMap(full));
        }
        props.put("jdk", this.jdk.asMap(full));
        props.put("targetJdks", mappedJdks);
        LinkedHashMap<String, Map<String, Object>> mappedJars = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.jars.size(); ++i) {
            mappedJars.put("glob " + i, this.jars.get(i).asMap(full));
        }
        props.put("jars", mappedJars);
        LinkedHashMap<String, Map<String, Object>> mappedFiles = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.files.size(); ++i) {
            mappedFiles.put("glob " + i, this.files.get(i).asMap(full));
        }
        props.put("files", mappedFiles);
    }
}

