/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Domain;
import org.jreleaser.model.Project;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class Signing
implements Domain,
Activatable {
    public static final String KEY_SKIP_SIGNING = "skipSigning";
    public static final String GPG_PASSPHRASE = "GPG_PASSPHRASE";
    public static final String GPG_PUBLIC_KEY = "GPG_PUBLIC_KEY";
    public static final String GPG_SECRET_KEY = "GPG_SECRET_KEY";
    private Active active;
    private boolean enabled;
    private Boolean armored;
    private String publicKey;
    private String secretKey;
    private String passphrase;
    private Mode mode;
    private Boolean artifacts;
    private Boolean files;
    private Boolean checksums;

    void setAll(Signing signing) {
        this.active = signing.active;
        this.enabled = signing.enabled;
        this.armored = signing.armored;
        this.publicKey = signing.publicKey;
        this.secretKey = signing.secretKey;
        this.passphrase = signing.passphrase;
        this.mode = signing.mode;
        this.artifacts = signing.artifacts;
        this.files = signing.files;
        this.checksums = signing.checksums;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.active = Active.of(str);
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public String getResolvedPublicKey() {
        return Env.resolve((String)GPG_PUBLIC_KEY, (String)this.publicKey);
    }

    public String getResolvedSecretKey() {
        return Env.resolve((String)GPG_SECRET_KEY, (String)this.secretKey);
    }

    public String getResolvedPassphrase() {
        return Env.resolve((String)GPG_PASSPHRASE, (String)this.passphrase);
    }

    public Boolean isArmored() {
        return this.armored != null && this.armored != false;
    }

    public void setArmored(Boolean armored) {
        this.armored = armored;
    }

    public boolean isArmoredSet() {
        return this.armored != null;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setMode(String str) {
        this.mode = Mode.of(str);
    }

    public boolean isArtifactsSet() {
        return this.artifacts != null;
    }

    public Boolean isArtifacts() {
        return this.artifacts == null || this.artifacts != false;
    }

    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    public Boolean isFiles() {
        return this.files == null || this.files != false;
    }

    public boolean isFilesSet() {
        return this.files != null;
    }

    public void setFiles(Boolean files) {
        this.files = files;
    }

    public boolean isChecksumsSet() {
        return this.checksums != null;
    }

    public Boolean isChecksums() {
        return this.checksums == null || this.checksums != false;
    }

    public void setChecksums(Boolean checksums) {
        this.checksums = checksums;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", (Object)this.active);
        props.put("armored", this.isArmored());
        props.put("mode", (Object)this.mode);
        props.put("artifacts", this.isArtifacts());
        props.put("files", this.isFiles());
        props.put("checksums", this.isChecksums());
        props.put("publicKey", StringUtils.isNotBlank((String)this.publicKey) ? "************" : "**unset**");
        props.put("secretKey", StringUtils.isNotBlank((String)this.secretKey) ? "************" : "**unset**");
        props.put("passphrase", StringUtils.isNotBlank((String)this.passphrase) ? "************" : "**unset**");
        return props;
    }

    public static enum Mode {
        MEMORY,
        FILE;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Mode of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Mode.valueOf(str.toUpperCase().trim());
        }
    }
}

