/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Artifactory;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.EnabledAware;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.HttpUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Uploader;
import org.jreleaser.util.StringUtils;

public class Upload
implements Domain,
EnabledAware {
    private final Map<String, Artifactory> artifactory = new LinkedHashMap<String, Artifactory>();
    private final Map<String, HttpUploader> http = new LinkedHashMap<String, HttpUploader>();
    private Boolean enabled;

    void setAll(Upload assemble) {
        this.enabled = assemble.enabled;
        this.setArtifactory(assemble.artifactory);
        this.setHttp(assemble.http);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public List<Artifactory> getActiveArtifactories() {
        return this.artifactory.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Artifactory> getArtifactory() {
        return this.artifactory;
    }

    public void setArtifactory(Map<String, Artifactory> artifactory) {
        this.artifactory.clear();
        this.artifactory.putAll(artifactory);
    }

    public void addArtifactory(Artifactory artifactory) {
        this.artifactory.put(artifactory.getType(), artifactory);
    }

    public Artifactory findArtifactory(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException("Artifactory name must not be blank");
        }
        if (this.artifactory.containsKey(name)) {
            return this.artifactory.get(name);
        }
        throw new JReleaserException("Artifactory '" + name + "' not found");
    }

    public List<HttpUploader> getActiveHttps() {
        return this.http.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, HttpUploader> getHttp() {
        return this.http;
    }

    public void setHttp(Map<String, HttpUploader> http) {
        this.http.clear();
        this.http.putAll(http);
    }

    public void addHttp(HttpUploader http) {
        this.http.put(http.getType(), http);
    }

    public HttpUploader findHttp(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException("HttpUploader name must not be blank");
        }
        if (this.http.containsKey(name)) {
            return this.http.get(name);
        }
        throw new JReleaserException("HttpUploader '" + name + "' not found");
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List http;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        List artifactory = this.artifactory.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!artifactory.isEmpty()) {
            map.put("artifactory", artifactory);
        }
        if (!(http = this.http.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("http", http);
        }
        return map;
    }

    public <A extends Uploader> Map<String, A> findUploadersByType(String uploaderType) {
        switch (uploaderType) {
            case "artifactory": {
                return this.artifactory;
            }
            case "http": {
                return this.http;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends Uploader> List<A> findAllUploaders() {
        ArrayList<AbstractUploader> uploaders = new ArrayList<AbstractUploader>();
        uploaders.addAll(this.getActiveArtifactories());
        uploaders.addAll(this.getActiveHttps());
        return uploaders;
    }

    public Map<String, String> resolveDownloadUrls(JReleaserContext context, Distribution distribution, Artifact artifact, String prefix) {
        Uploader uploader;
        List<String> keys;
        LinkedHashMap<String, String> urls = new LinkedHashMap<String, String>();
        List uploaders = this.findAllUploaders();
        for (Uploader uploader2 : uploaders) {
            List<String> keys2 = uploader2.resolveSkipKeys();
            if (this.isSkip(distribution, keys2) || this.isSkip(artifact, keys2)) continue;
            String key = prefix + "Download" + StringUtils.capitalize((String)uploader2.getType()) + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)uploader2.getName()) + "Url";
            String url = uploader2.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
            if (this.findUploadersByType(uploader2.getType()).size() != 1 || this.isSkip(distribution, keys2) || this.isSkip(artifact, keys2)) continue;
            key = prefix + "Download" + StringUtils.capitalize((String)uploader2.getType()) + "Url";
            url = uploader2.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
        }
        if (uploaders.size() == 1 && !this.isSkip(distribution, keys = (uploader = (Uploader)uploaders.get(0)).resolveSkipKeys()) && !this.isSkip(artifact, keys)) {
            String key = prefix + "DownloadUrl";
            String url = uploader.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
        }
        return urls;
    }

    private boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }
}

