/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Webhook;
import org.jreleaser.util.StringUtils;

public class Webhooks
extends AbstractAnnouncer {
    public static final String NAME = "webhooks";
    private final Map<String, Webhook> webhooks = new LinkedHashMap<String, Webhook>();

    public Webhooks() {
        super(NAME);
    }

    void setAll(Webhooks webhook) {
        super.setAll(webhook);
        this.setWebhooks(webhook.webhooks);
    }

    public List<Webhook> getActiveWebhooks() {
        return this.webhooks.values().stream().filter(AbstractAnnouncer::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Webhook> getWebhooks() {
        return this.webhooks;
    }

    public void setWebhooks(Map<String, Webhook> webhooks) {
        this.webhooks.clear();
        this.webhooks.putAll(webhooks);
    }

    public void addWebhook(Webhook webhook) {
        this.webhooks.put(webhook.getName(), webhook);
    }

    public Webhook findWebhook(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException("Webhook name must not be blank");
        }
        if (this.webhooks.containsKey(name)) {
            return this.webhooks.get(name);
        }
        throw new JReleaserException("Webhook '" + name + "' not found");
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        this.asMap(props, full);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        this.webhooks.values().stream().filter(AbstractAnnouncer::isEnabled).map(d -> d.asMap(full)).forEach(props::putAll);
    }
}

