/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.util;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Files;
import org.jreleaser.model.Glob;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;

public class Artifacts {
    public static Path checkAndCopyFile(JReleaserContext context, Path src, Path dest) throws JReleaserException {
        if (null == dest) {
            return src;
        }
        if (!java.nio.file.Files.exists(dest, new LinkOption[0])) {
            context.getLogger().debug("artifact does not exist: {}", new Object[]{context.relativizeToBasedir(dest)});
            Artifacts.copyFile(context, src, dest);
        } else if (src.toFile().lastModified() > dest.toFile().lastModified()) {
            context.getLogger().debug("{} is newer than {}", new Object[]{context.relativizeToBasedir(src), context.relativizeToBasedir(dest)});
            Artifacts.copyFile(context, src, dest);
        }
        return dest;
    }

    public static void copyFile(JReleaserContext context, Path src, Path dest) throws JReleaserException {
        try {
            java.nio.file.Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            java.nio.file.Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            throw new JReleaserException("Unexpected error copying " + context.relativizeToBasedir(src) + " to " + context.relativizeToBasedir(dest));
        }
    }

    public static Set<Artifact> resolveFiles(JReleaserContext context) throws JReleaserException {
        Files files = context.getModel().getFiles();
        if (files.arePathsResolved()) {
            return files.getPaths();
        }
        LinkedHashSet<Artifact> paths = new LinkedHashSet<Artifact>();
        for (Artifact artifact : files.getArtifacts()) {
            if (!context.isPlatformSelected(artifact)) continue;
            artifact.activate();
            artifact.getEffectivePath(context);
            paths.add(artifact);
        }
        for (Glob glob : files.getGlobs()) {
            for (Artifact artifact : glob.getResolvedArtifacts(context)) {
                if (!artifact.isActive()) continue;
                paths.add(artifact);
            }
        }
        files.setPaths(Artifact.sortArtifacts(paths));
        return files.getPaths();
    }

    public static Set<Artifact> resolveFiles(JReleaserLogger logger, Path basedir, Collection<String> globs) throws JReleaserException {
        if (null == globs || globs.isEmpty()) {
            return Collections.emptySet();
        }
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String glob : globs) {
            matchers.add(fileSystem.getPathMatcher(glob));
        }
        GlobResolver resolver = new GlobResolver(logger, basedir, matchers);
        try {
            java.nio.file.Files.walkFileTree(basedir, resolver);
            if (resolver.failed) {
                throw new JReleaserException("Some globs failed to be resolved.");
            }
            return Artifact.sortArtifacts(resolver.artifacts);
        }
        catch (IOException e) {
            throw new JReleaserException("Unexpected error when resolving globs", e);
        }
    }

    public static Set<Artifact> resolveFiles(JReleaserLogger logger, Map<String, Object> props, Path basedir, Collection<String> globs) throws JReleaserException {
        if (null == globs || globs.isEmpty()) {
            return Collections.emptySet();
        }
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String glob : globs) {
            matchers.add(fileSystem.getPathMatcher(MustacheUtils.applyTemplate((String)glob, props)));
        }
        GlobResolver resolver = new GlobResolver(logger, basedir, matchers);
        try {
            java.nio.file.Files.walkFileTree(basedir, resolver);
            if (resolver.failed) {
                throw new JReleaserException("Some globs failed to be resolved.");
            }
            return Artifact.sortArtifacts(resolver.artifacts);
        }
        catch (IOException e) {
            throw new JReleaserException("Unexpected error when resolving globs", e);
        }
    }

    public static Set<Artifact> resolveFiles(JReleaserContext context, Collection<String> globs) throws JReleaserException {
        return Artifacts.resolveFiles(context.getLogger(), context.props(), context.getBasedir(), globs);
    }

    private static class GlobResolver
    extends SimpleFileVisitor<Path> {
        private final JReleaserLogger logger;
        private final List<PathMatcher> matchers;
        private final Path basedir;
        private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
        private boolean failed;

        private GlobResolver(JReleaserLogger logger, Path basedir, List<PathMatcher> matchers) {
            this.logger = logger;
            this.matchers = matchers;
            this.basedir = basedir;
        }

        private void match(Path path) {
            if (this.matchers.stream().anyMatch(matcher -> matcher.matches(path))) {
                this.artifacts.add(Artifact.of(path));
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.match(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            this.failed = true;
            this.logger.error("Unexpected error visiting path " + this.basedir.toAbsolutePath().relativize(file.toAbsolutePath()), (Throwable)e);
            return FileVisitResult.CONTINUE;
        }
    }
}

