/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.model.Discord;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class DiscordValidator
extends Validator {
    private static final String DEFAULT_DISCORD_TPL = "src/jreleaser/templates/discord.tpl";

    public static void validateDiscord(JReleaserContext context, Discord discord, Errors errors) {
        if (!discord.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.discord");
        discord.setWebhook(DiscordValidator.checkProperty(context, "DISCORD_WEBHOOK", "discord.webhook", discord.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)discord.getMessage()) && StringUtils.isBlank((String)discord.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_DISCORD_TPL), new LinkOption[0])) {
                discord.setMessageTemplate(DEFAULT_DISCORD_TPL);
            } else {
                discord.setMessage("\ud83d\ude80 {{projectNameCapitalized}} {{projectVersion}} has been released! {{releaseNotesUrl}}");
            }
        }
        if (StringUtils.isNotBlank((String)discord.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(discord.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration("discord.messageTemplate does not exist. " + discord.getMessageTemplate());
        }
        DiscordValidator.validateTimeout(discord);
    }
}

