/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.model.Discussions;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class DiscussionsValidator
extends Validator {
    private static final String DEFAULT_DISCUSSIONS_TPL = "src/jreleaser/templates/discussions.tpl";

    public static void validateDiscussions(JReleaserContext context, Discussions discussions, Errors errors) {
        if (!discussions.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.discussions");
        if (!"github".equals(context.getModel().getRelease().getGitService().getServiceName())) {
            errors.configuration("discussions may only be used when releasing to GitHub");
            discussions.disable();
            return;
        }
        if (StringUtils.isBlank((String)discussions.getOrganization())) {
            errors.configuration("discussions.organization must not be blank.");
        }
        if (StringUtils.isBlank((String)discussions.getTeam())) {
            errors.configuration("discussions.team must not be blank.");
        }
        if (StringUtils.isBlank((String)discussions.getTitle())) {
            discussions.setTitle("{{projectNameCapitalized}} {{projectVersion}} released!");
        }
        if (StringUtils.isBlank((String)discussions.getMessage()) && StringUtils.isBlank((String)discussions.getMessageTemplate())) {
            discussions.setMessageTemplate(DEFAULT_DISCUSSIONS_TPL);
        }
        if (StringUtils.isBlank((String)discussions.getMessage()) && StringUtils.isBlank((String)discussions.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_DISCUSSIONS_TPL), new LinkOption[0])) {
                discussions.setMessageTemplate(DEFAULT_DISCUSSIONS_TPL);
            } else {
                discussions.setMessage("\ud83d\ude80 {{projectNameCapitalized}} {{projectVersion}} has been released! {{releaseNotesUrl}}");
            }
        }
        if (StringUtils.isNotBlank((String)discussions.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(discussions.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration("discussions.messageTemplate does not exist. " + discussions.getMessageTemplate());
        }
        DiscussionsValidator.validateTimeout(discussions);
    }
}

