/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Tool;
import org.jreleaser.model.validation.BrewValidator;
import org.jreleaser.model.validation.ChocolateyValidator;
import org.jreleaser.model.validation.DockerValidator;
import org.jreleaser.model.validation.JbangValidator;
import org.jreleaser.model.validation.ScoopValidator;
import org.jreleaser.model.validation.SdkmanValidator;
import org.jreleaser.model.validation.SnapValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class DistributionsValidator
extends Validator {
    public static void validateDistributions(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (mode != JReleaserContext.Mode.FULL) {
            return;
        }
        context.getLogger().debug("distributions");
        Map<String, Distribution> distributions = context.getModel().getDistributions();
        for (Map.Entry<String, Distribution> e : distributions.entrySet()) {
            Distribution distribution = e.getValue();
            if (StringUtils.isBlank((String)distribution.getName())) {
                distribution.setName(e.getKey());
            }
            DistributionsValidator.validateDistribution(context, distribution, errors);
        }
        BrewValidator.postValidateBrew(context, errors);
        JbangValidator.postValidateJBang(context, errors);
        SdkmanValidator.postValidateSdkman(context, errors);
    }

    private static void validateDistribution(JReleaserContext context, Distribution distribution, Errors errors) {
        context.getLogger().debug("distribution.{}", new Object[]{distribution.getName()});
        if (!distribution.isActiveSet()) {
            distribution.setActive(Active.ALWAYS);
        }
        if (!distribution.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (!DistributionsValidator.selectArtifactsByPlatform(context, distribution)) {
            distribution.setActive(Active.NEVER);
            distribution.disable();
            return;
        }
        if (StringUtils.isBlank((String)distribution.getName())) {
            errors.configuration("distribution.name must not be blank");
            return;
        }
        if (null == distribution.getType()) {
            errors.configuration("distribution." + distribution.getName() + ".type must not be null");
            return;
        }
        if (StringUtils.isBlank((String)distribution.getExecutable())) {
            distribution.setExecutable(distribution.getName());
        }
        if (Distribution.JAVA_DISTRIBUTION_TYPES.contains((Object)distribution.getType())) {
            context.getLogger().debug("distribution.{}.java", new Object[]{distribution.getName()});
            if (!DistributionsValidator.validateJava(context, distribution, errors)) {
                return;
            }
        }
        if (!distribution.getJava().isEnabled() && Distribution.JAVA_DISTRIBUTION_TYPES.contains((Object)distribution.getType())) {
            errors.configuration("distribution." + distribution.getName() + ".type is set to " + (Object)((Object)distribution.getType()) + " but neither distribution." + distribution.getName() + ".java nor project.java have been set");
            return;
        }
        if (null == distribution.getArtifacts() || distribution.getArtifacts().isEmpty()) {
            errors.configuration("distribution." + distribution.getName() + ".artifacts is empty");
            return;
        }
        ArrayList<String> tags = new ArrayList<String>();
        tags.addAll(context.getModel().getProject().getTags());
        tags.addAll(distribution.getTags());
        distribution.setTags(tags);
        int i = 0;
        for (Artifact artifact2 : distribution.getArtifacts()) {
            if (!artifact2.isActive()) continue;
            DistributionsValidator.validateArtifact(context, distribution, artifact2, i++, errors);
            if (!distribution.getExtraProperties().containsKey("skipReleaseSignatures") || artifact2.getExtraProperties().containsKey("skipReleaseSignatures")) continue;
            artifact2.getExtraProperties().put("skipReleaseSignatures", distribution.getExtraProperties().get("skipReleaseSignatures"));
        }
        Map<String, List<Artifact>> byPlatform = distribution.getArtifacts().stream().filter(Artifact::isActive).collect(Collectors.groupingBy(artifact -> StringUtils.isBlank((String)artifact.getPlatform()) ? "<nil>" : artifact.getPlatform()));
        byPlatform.forEach((p, artifacts) -> {
            String platform = "<nil>".equals(p) ? "no" : p;
            artifacts.stream().collect(Collectors.groupingBy(artifact -> {
                String ext = StringUtils.getFilenameExtension((String)artifact.getPath());
                return StringUtils.isNotBlank((String)ext) ? ext : "";
            })).forEach((ext, matches) -> {
                if (matches.size() > 1) {
                    errors.configuration("distribution." + distribution.getName() + " has more than one artifact with " + platform + " platform for extension " + ext);
                }
            });
        });
        BrewValidator.validateBrew(context, distribution, distribution.getBrew(), errors);
        ChocolateyValidator.validateChocolatey(context, distribution, distribution.getChocolatey(), errors);
        DockerValidator.validateDocker(context, distribution, distribution.getDocker(), errors);
        JbangValidator.validateJbang(context, distribution, distribution.getJbang(), errors);
        ScoopValidator.validateScoop(context, distribution, distribution.getScoop(), errors);
        SdkmanValidator.validateSdkman(context, distribution, distribution.getSdkman(), errors);
        SnapValidator.validateSnap(context, distribution, distribution.getSnap(), errors);
    }

    private static boolean selectArtifactsByPlatform(JReleaserContext context, Distribution distribution) {
        boolean activeArtifacts = false;
        for (Artifact artifact : distribution.getArtifacts()) {
            if (!context.isPlatformSelected(artifact)) continue;
            artifact.activate();
            activeArtifacts = true;
        }
        return activeArtifacts;
    }

    private static boolean validateJava(JReleaserContext context, Distribution distribution, Errors errors) {
        Project project = context.getModel().getProject();
        if (!distribution.getJava().isEnabledSet() && project.getJava().isSet()) {
            distribution.getJava().setEnabled(project.getJava().isSet());
        }
        if (!distribution.getJava().isEnabledSet()) {
            distribution.getJava().setEnabled(distribution.getJava().isSet());
        }
        if (distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE) {
            distribution.getJava().setEnabled(false);
        }
        if (!distribution.getJava().isEnabled()) {
            return true;
        }
        if (StringUtils.isBlank((String)distribution.getJava().getArtifactId())) {
            distribution.getJava().setArtifactId(distribution.getName());
        }
        if (StringUtils.isBlank((String)distribution.getJava().getGroupId())) {
            distribution.getJava().setGroupId(project.getJava().getGroupId());
        }
        if (StringUtils.isBlank((String)distribution.getJava().getVersion())) {
            distribution.getJava().setVersion(project.getJava().getVersion());
        }
        if (StringUtils.isBlank((String)distribution.getJava().getMainClass())) {
            distribution.getJava().setMainClass(project.getJava().getMainClass());
        }
        if (distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE) {
            return true;
        }
        if (StringUtils.isBlank((String)distribution.getJava().getGroupId())) {
            errors.configuration("distribution." + distribution.getName() + ".java.groupId must not be blank");
        }
        if (!distribution.getJava().isMultiProjectSet()) {
            distribution.getJava().setMultiProject(project.getJava().isMultiProject());
        }
        if (!Distribution.JAVA_DISTRIBUTION_TYPES.contains((Object)distribution.getType())) {
            errors.configuration("distribution." + distribution.getName() + ".type must be a valid Java distribution type, one of [" + Distribution.JAVA_DISTRIBUTION_TYPES.stream().map(Enum::name).collect(Collectors.joining(", ")) + "]");
            return false;
        }
        return true;
    }

    private static void validateArtifact(JReleaserContext context, Distribution distribution, Artifact artifact, int index, Errors errors) {
        if (null == artifact) {
            errors.configuration("distribution." + distribution.getName() + ".artifact[" + index + "] is null");
            return;
        }
        if (StringUtils.isBlank((String)artifact.getPath())) {
            errors.configuration("distribution." + distribution.getName() + ".artifact[" + index + "].path must not be null");
        }
        if (StringUtils.isNotBlank((String)artifact.getPlatform()) && !PlatformUtils.isSupported((String)artifact.getPlatform().trim())) {
            context.getLogger().warn("distribution.{}.artifact[{}].platform ({}) is not supported. Please use `${name}` or `${name}-${arch}` from{}       name = {}{}       arch = {}", new Object[]{distribution.getName(), index, artifact.getPlatform(), System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()});
        }
    }

    public static void validateArtifactPlatforms(JReleaserContext context, Distribution distribution, Tool tool, Errors errors) {
        if (distribution.getType() == Distribution.DistributionType.BINARY || distribution.getType() == Distribution.DistributionType.JLINK || distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE || distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE) {
            Set<String> fileExtensions = tool.getSupportedExtensions();
            String noPlatform = "<nil>";
            Map<String, List<Artifact>> byPlatform = distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> fileExtensions.stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).collect(Collectors.groupingBy(artifact -> StringUtils.isBlank((String)artifact.getPlatform()) ? noPlatform : artifact.getPlatform()));
            if (byPlatform.containsKey(noPlatform)) {
                errors.configuration("distribution." + distribution.getName() + " is of type " + (Object)((Object)distribution.getType()) + " and " + tool.getName() + " requires a explicit platform on each artifact");
            }
            if (byPlatform.keySet().stream().noneMatch(tool::supportsPlatform)) {
                context.getLogger().warn("disabling distribution." + distribution.getName() + "." + tool.getName() + " because there are no matching artifacts");
                tool.disable();
            }
        }
    }
}

